/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.PairIterator;
import org.codefilarete.tool.collection.ReverseListIterator;
import org.junit.jupiter.api.Test;

public class ReverseListIteratorTest {
    @Test
    public void testIteration() {
        List toReverse = Arrays.asList((Object[])new String[]{"a", "b", "c"});
        List expected = Arrays.asList((Object[])new String[]{"c", "b", "a"});
        ReverseListIterator iterator = new ReverseListIterator(toReverse);
        PairIterator pairIterator = new PairIterator((Iterator)iterator, expected.iterator());
        while (pairIterator.hasNext()) {
            Duo next = pairIterator.next();
            Assertions.assertThat((String)((String)next.getRight())).isEqualTo((String)next.getLeft());
        }
    }

    @Test
    public void testIteration_empty() {
        ReverseListIterator iterator = new ReverseListIterator(Arrays.asList((Object[])new Object[0]));
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void testRemove() {
        ArrayList toModify = new ArrayList(Arrays.asList((Object[])new String[]{"a", "b", "c"}));
        ReverseListIterator iterator = new ReverseListIterator(toModify);
        iterator.next();
        iterator.remove();
        Assertions.assertThat(toModify).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", "b"}));
        Assertions.assertThat((String)((String)iterator.next())).isEqualTo("b");
    }
}

