/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.bean.FieldIterator;
import org.codefilarete.tool.bean.MethodIterator;
import org.codefilarete.tool.collection.ArrayIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.PairIterator;
import org.codefilarete.tool.function.ThrowingFunction;
import org.codefilarete.tool.reflect.MemberPrinter;

public final class Reflections {
    public static final String FLAT_PACKAGES_OPTION_KEY = "reflections.flatPackages";
    public static final Set<String> DISABLE_FLAT_PACKAGES_OPTIONS = Collections.unmodifiableSet(Arrays.asHashSet("disable", "false", "off"));
    public static final Function<String, String> GET_SET_PREFIX_REMOVER = methodName -> methodName.substring(3);
    public static final Function<String, String> IS_PREFIX_REMOVER = methodName -> methodName.substring(2);
    public static final Function<Method, String> JAVA_BEAN_ACCESSOR_PREFIX_REMOVER = method -> GET_SET_PREFIX_REMOVER.apply(method.getName());
    public static final Function<Method, String> JAVA_BEAN_BOOLEAN_ACCESSOR_PREFIX_REMOVER = method -> IS_PREFIX_REMOVER.apply(method.getName());
    public static final Predicate<String> JAVA_BEAN_METHOD_NAME_CONVENTION_MATCHER = methodName -> Reflections.onJavaBeanPropertyWrapperNameGeneric(methodName, methodName, s -> true, s -> true, s -> true, s -> false);
    public static final Predicate<Method> JAVA_BEAN_METHOD_CONVENTION_MATCHER = method -> Reflections.onJavaBeanPropertyWrapperNameGeneric(method.getName(), method, s -> true, s -> true, s -> true, s -> false);
    public static final Map<Class, Object> PRIMITIVE_DEFAULT_VALUES = Collections.unmodifiableMap(Maps.forHashMap(Class.class, Object.class).add(Boolean.TYPE, false).add(Boolean.class, false).add(Character.TYPE, Character.valueOf('\u0000')).add(Character.class, Character.valueOf('\u0000')).add(Byte.TYPE, (byte)0).add(Byte.class, (byte)0).add(Short.TYPE, (short)0).add(Short.class, (short)0).add(Integer.TYPE, 0).add(Integer.class, 0).add(Long.TYPE, 0L).add(Long.class, 0L).add(Float.TYPE, Float.valueOf(0.0f)).add(Float.class, Float.valueOf(0.0f)).add(Double.TYPE, 0.0).add(Double.class, 0.0));
    private static final Set<Class> PRIMITIVE_TYPES = Collections.unmodifiableSet(Arrays.asHashSet(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE));
    public static final ThreadLocal<Optional<String>> PACKAGES_PRINT_MODE_CONTEXT = ThreadLocal.withInitial(() -> Optional.ofNullable(System.getProperty(FLAT_PACKAGES_OPTION_KEY)));
    private static final Supplier<MemberPrinter> MEMBER_PRINTER = () -> {
        Optional<String> flattenPackageOption = PACKAGES_PRINT_MODE_CONTEXT.get();
        return flattenPackageOption.filter(DISABLE_FLAT_PACKAGES_OPTIONS::contains).isPresent() ? MemberPrinter.FULL_PACKAGE_PRINTER : MemberPrinter.FLATTEN_PACKAGE_PRINTER;
    };

    public static void ensureAccessible(AccessibleObject accessibleObject) {
        if (!accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
    }

    public static <T> Constructor<T> getDefaultConstructor(@Nonnull Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String reason;
            Optional<MissingDefaultConstructorReason> missingDefaultConstructorReason = Reflections.giveMissingDefaultConstructorReason(clazz);
            if (missingDefaultConstructorReason.isPresent()) {
                switch (missingDefaultConstructorReason.get()) {
                    case INNER_CLASS: {
                        reason = " because it is an inner non static class (needs an instance of the enclosing class to be constructed)";
                        break;
                    }
                    case INTERFACE: {
                        reason = " because it is an interface";
                        break;
                    }
                    case PRIMITIVE: {
                        reason = " because it is a primitive type";
                        break;
                    }
                    case ARRAY: {
                        reason = " because it is an array";
                        break;
                    }
                    default: {
                        reason = " for undetermined reason";
                        break;
                    }
                }
            } else {
                reason = "";
            }
            throw new UnsupportedOperationException("Class " + Reflections.toString(clazz) + " has no default constructor" + reason);
        }
    }

    private static Optional<MissingDefaultConstructorReason> giveMissingDefaultConstructorReason(Class<?> clazz) {
        Optional<MissingDefaultConstructorReason> result = Optional.empty();
        if (Reflections.isInnerClass(clazz)) {
            result = Optional.of(MissingDefaultConstructorReason.INNER_CLASS);
        } else if (Modifier.isInterface(clazz.getModifiers())) {
            result = Optional.of(MissingDefaultConstructorReason.INTERFACE);
        } else if (clazz.isPrimitive()) {
            result = Optional.of(MissingDefaultConstructorReason.PRIMITIVE);
        } else if (clazz.isArray()) {
            result = Optional.of(MissingDefaultConstructorReason.ARRAY);
        }
        return result;
    }

    public static boolean isInnerClass(@Nonnull Class<?> clazz) {
        return clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isStatic(@Nonnull Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isStatic(@Nonnull Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static boolean isStatic(@Nonnull Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static Map<String, Field> mapFieldsOnName(Class<?> clazz) {
        return Iterables.map(() -> new FieldIterator(clazz), Field::getName);
    }

    @javax.annotation.Nullable
    public static Field findField(Class<?> clazz, String name) {
        return Iterables.stream(new FieldIterator(clazz)).filter(field -> field.getName().equals(name)).findAny().orElse(null);
    }

    public static Field getField(Class<?> clazz, String name) {
        Field field = Reflections.findField(clazz, name);
        if (field == null) {
            String className = Reflections.toString(clazz);
            throw new MemberNotFoundException(className + "." + name, "Field " + name + " on " + className + " was not found");
        }
        return field;
    }

    @javax.annotation.Nullable
    public static Method findMethod(Class<?> clazz, String name, Class<?> ... argTypes) {
        return Iterables.stream(new MethodIterator(clazz, null)).filter(method -> method.getName().equals(name) && method.getParameterTypes().length == argTypes.length).filter(method -> {
            PairIterator argsIterator = new PairIterator(new ArrayIterator(method.getParameterTypes()), new ArrayIterator<Class>(argTypes));
            boolean argsAreCompatible = true;
            while (argsAreCompatible && argsIterator.hasNext()) {
                Object next = argsIterator.next();
                argsAreCompatible = Reflections.isAssignableFrom((Class)((Duo)next).getLeft(), (Class)((Duo)next).getRight());
            }
            return argsAreCompatible;
        }).findAny().orElse(null);
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... argTypes) {
        Method method = Reflections.findMethod(clazz, name, argTypes);
        if (method == null) {
            String className = Reflections.toString(clazz);
            String args = new StringAppender().ccat((Object[])argTypes, (Object)", ").toString();
            throw new MemberNotFoundException(className + "." + name + "(" + args + ")", "Method " + name + "(" + args + ") on " + className + " was not found");
        }
        return method;
    }

    @javax.annotation.Nullable
    public static <C> Constructor<C> findConstructor(Class<C> clazz, Class<?> ... argTypes) {
        try {
            return Reflections.getConstructor(clazz, argTypes);
        }
        catch (MemberNotFoundException e) {
            return null;
        }
    }

    public static <C> Constructor<C> getConstructor(Class<C> clazz, Class<?> ... argTypes) {
        try {
            return clazz.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            String className = Reflections.toString(clazz);
            MemberNotFoundException detailedException = new MemberNotFoundException(className + ".<init>", "Constructor of " + className + " with arguments (" + new StringAppender().ccat((Object[])argTypes, (Object)", ") + ") was not found");
            if (Reflections.isInnerClass(clazz) && (argTypes.length == 0 || argTypes[0] != clazz.getEnclosingClass())) {
                throw new MemberNotFoundException(className + ".<init>", "Non static inner classes require an enclosing class parameter as first argument", detailedException);
            }
            throw detailedException;
        }
    }

    public static <E> E newInstance(Class<E> clazz) {
        try {
            return Reflections.newInstance(Reflections.getDefaultConstructor(clazz), new Object[0]);
        }
        catch (UnsupportedOperationException e) {
            throw new InvokationRuntimeException("Class " + Reflections.toString(clazz) + " can't be instantiated", e);
        }
    }

    public static <E> E newInstance(Constructor<E> constructor, Object ... args) {
        try {
            Reflections.ensureAccessible(constructor);
            return constructor.newInstance(args);
        }
        catch (ReflectiveOperationException e) {
            if (e instanceof InstantiationException && Modifier.isAbstract(constructor.getDeclaringClass().getModifiers())) {
                throw new InvokationRuntimeException("Class " + Reflections.toString(constructor.getDeclaringClass()) + " can't be instantiated because it is abstract", e);
            }
            throw new InvokationRuntimeException("Class " + Reflections.toString(constructor.getDeclaringClass()) + " can't be instantiated", e);
        }
    }

    public static Object invoke(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new InvokationRuntimeException(e);
        }
    }

    public static Field wrappedField(Method fieldWrapper) {
        String fieldName = Reflections.propertyName(fieldWrapper);
        return Reflections.findField(fieldWrapper.getDeclaringClass(), fieldName);
    }

    public static String propertyName(Method fieldWrapper) {
        String propertyName = Reflections.onJavaBeanPropertyWrapperName(fieldWrapper, JAVA_BEAN_ACCESSOR_PREFIX_REMOVER, JAVA_BEAN_ACCESSOR_PREFIX_REMOVER, JAVA_BEAN_BOOLEAN_ACCESSOR_PREFIX_REMOVER);
        propertyName = Strings.uncapitalize(propertyName);
        return propertyName;
    }

    public static String propertyName(String methodName) {
        String propertyName = Reflections.onJavaBeanPropertyWrapperName(methodName, GET_SET_PREFIX_REMOVER, GET_SET_PREFIX_REMOVER, IS_PREFIX_REMOVER);
        propertyName = Strings.uncapitalize(propertyName);
        return propertyName;
    }

    public static <E> E onJavaBeanPropertyWrapper(Method fieldWrapper, Function<Method, E> getterAction, Function<Method, E> setterAction, Function<Method, E> booleanGetterAction) {
        int parameterCount = fieldWrapper.getParameterCount();
        Class<?> returnType = fieldWrapper.getReturnType();
        MemberNotFoundException exception = Reflections.newEncapsulationException(() -> Reflections.toString(fieldWrapper));
        return Reflections.onJavaBeanPropertyWrapperName(fieldWrapper, new GetOrThrow(getterAction, () -> parameterCount == 0 && returnType != Void.class, () -> exception), new GetOrThrow(setterAction, () -> parameterCount == 1 && returnType == Void.TYPE, () -> exception), new GetOrThrow(booleanGetterAction, () -> parameterCount == 0 && returnType == Boolean.TYPE, () -> exception));
    }

    public static <E> E onJavaBeanPropertyWrapperName(Method fieldWrapper, Function<Method, E> getterAction, Function<Method, E> setterAction, Function<Method, E> booleanGetterAction) {
        return Reflections.onJavaBeanPropertyWrapperName(fieldWrapper.getName(), fieldWrapper, getterAction, setterAction, booleanGetterAction, () -> Reflections.toString(fieldWrapper));
    }

    public static <E> E onJavaBeanPropertyWrapperName(String methodName, Function<String, E> getterAction, Function<String, E> setterAction, Function<String, E> booleanGetterAction) {
        return Reflections.onJavaBeanPropertyWrapperName(methodName, methodName, getterAction, setterAction, booleanGetterAction, () -> methodName);
    }

    private static MemberNotFoundException newEncapsulationException(Supplier<String> methodName) {
        return new MemberNotFoundException(methodName.get(), "Field wrapper " + methodName.get() + " doesn't fit encapsulation naming convention");
    }

    private static <I, E> E onJavaBeanPropertyWrapperName(String methodName, I input, Function<I, E> getterAction, Function<I, E> setterAction, Function<I, E> booleanGetterAction, Supplier<String> inputToString) {
        return (E)Reflections.onJavaBeanPropertyWrapperNameGeneric(methodName, input, getterAction, setterAction, booleanGetterAction, i -> {
            throw Reflections.newEncapsulationException(inputToString);
        });
    }

    public static <I, E> E onJavaBeanPropertyWrapperNameGeneric(String methodName, I input, Function<I, E> getterAction, Function<I, E> setterAction, Function<I, E> booleanGetterAction, ThrowingFunction<I, E, ? extends RuntimeException> onNonCompliantName) {
        if (methodName.startsWith("get")) {
            return getterAction.apply(input);
        }
        if (methodName.startsWith("set")) {
            return setterAction.apply(input);
        }
        if (methodName.startsWith("is")) {
            return booleanGetterAction.apply(input);
        }
        return onNonCompliantName.apply(input);
    }

    public static <C> Class<C> javaBeanTargetType(Method method) {
        return Reflections.onJavaBeanPropertyWrapper(method, Method::getReturnType, m -> m.getParameterTypes()[0], m -> Boolean.TYPE);
    }

    public static String toString(Field field) {
        return MEMBER_PRINTER.get().toString(field);
    }

    public static String toString(Constructor<?> constructor) {
        return MEMBER_PRINTER.get().toString(constructor);
    }

    public static String toString(Method method) {
        return MEMBER_PRINTER.get().toString(method);
    }

    public static String toString(Executable executable) {
        return MEMBER_PRINTER.get().toString(executable);
    }

    public static String toString(Class<?> clazz) {
        return MEMBER_PRINTER.get().toString(clazz);
    }

    public static Class forName(String typeName) {
        switch (typeName) {
            case "Z": {
                return Boolean.TYPE;
            }
            case "B": {
                return Byte.TYPE;
            }
            case "C": {
                return Character.TYPE;
            }
            case "D": {
                return Double.TYPE;
            }
            case "F": {
                return Float.TYPE;
            }
            case "I": {
                return Integer.TYPE;
            }
            case "J": {
                return Long.TYPE;
            }
            case "S": {
                return Short.TYPE;
            }
            case "V": {
                return Void.TYPE;
            }
        }
        if (typeName.startsWith("L") && typeName.endsWith(";")) {
            typeName = typeName.substring(1, typeName.length() - 1);
        }
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new MemberNotFoundException(typeName, e);
        }
    }

    public static <I> I newProxy(Class<I> iface, InvocationHandler invocationHandler, Class<?> ... additionalInterfaces) {
        return (I)Proxy.newProxyInstance(iface.getClassLoader(), Arrays.cat(new Class[]{iface}, additionalInterfaces), invocationHandler);
    }

    public static Class giveWrapperClass(Class<?> clazz) {
        return Nullable.nullable(Reflections.findWrapperClass(clazz)).getOrThrow(() -> new IllegalArgumentException("Given type is not a primitive one : " + Reflections.toString(clazz)));
    }

    @javax.annotation.Nullable
    public static Class findWrapperClass(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return null;
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return PRIMITIVE_TYPES.contains(type);
    }

    public static boolean isComplexType(Class<?> type) {
        return !Reflections.isPrimitiveType(type);
    }

    public static boolean isAssignableFrom(Class<?> aClass, Class<?> otherClass) {
        return aClass.isAssignableFrom(otherClass) || aClass.equals(Reflections.findWrapperClass(otherClass)) || otherClass.equals(Reflections.findWrapperClass(aClass));
    }

    public static class InvokationRuntimeException
    extends RuntimeException {
        public InvokationRuntimeException(String message) {
            super(message);
        }

        public InvokationRuntimeException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvokationRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    public static class MemberNotFoundException
    extends RuntimeException {
        private final String memberName;

        public MemberNotFoundException(String memberName, String message) {
            super(message);
            this.memberName = memberName;
        }

        public MemberNotFoundException(String memberName, String message, Throwable cause) {
            super(message, cause);
            this.memberName = memberName;
        }

        public MemberNotFoundException(String memberName, Throwable cause) {
            super(cause);
            this.memberName = memberName;
        }

        public String getMemberName() {
            return this.memberName;
        }
    }

    private static enum MissingDefaultConstructorReason {
        INNER_CLASS,
        INTERFACE,
        PRIMITIVE,
        ARRAY;

    }

    private static class GetOrThrow<E>
    implements Function<Method, E> {
        private final Function<Method, E> delegate;
        private final Checker predicate;
        private final Supplier<RuntimeException> throwableSupplier;

        private GetOrThrow(Function<Method, E> delegate, Checker predicate, Supplier<RuntimeException> s) {
            this.delegate = delegate;
            this.predicate = predicate;
            this.throwableSupplier = s;
        }

        @Override
        public E apply(Method method) {
            if (this.predicate.check()) {
                return this.delegate.apply(method);
            }
            throw this.throwableSupplier.get();
        }
    }

    @FunctionalInterface
    private static interface Checker {
        public boolean check();
    }
}

