/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Iterator;
import java.util.function.Consumer;

public abstract class ReadOnlyIterator<E>
implements Iterator<E> {
    public static <C> ReadOnlyIterator<C> wrap(Iterable<C> iterable) {
        return new ReadOnlyWrappedIterator<C>(iterable.iterator());
    }

    public static <C> ReadOnlyIterator<C> wrap(Iterator<C> iterator) {
        return new ReadOnlyWrappedIterator<C>(iterator);
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private static class ReadOnlyWrappedIterator<C>
    extends ReadOnlyIterator<C> {
        private final Iterator<C> delegate;

        public ReadOnlyWrappedIterator(Iterator<C> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public C next() {
            return this.delegate.next();
        }

        @Override
        public void forEachRemaining(Consumer<? super C> action) {
            this.delegate.forEachRemaining(action);
        }
    }
}

