/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.reflect;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.function.Hanger;
import org.codefilarete.tool.reflect.MethodDispatcher;
import org.codefilarete.tool.trace.MutableInt;
import org.junit.jupiter.api.Test;

class MethodDispatcherTest {
    MethodDispatcherTest() {
    }

    @Test
    void redirect_interface() {
        IntegerHanger surrogate = new IntegerHanger();
        Holder1 testInstance = (Holder1)new MethodDispatcher().redirect(Hanger.class, (Object)surrogate).fallbackOn((Object)666).build(Holder1.class);
        testInstance.set(42);
        Assertions.assertThat((int)surrogate.getValue()).isEqualTo(42);
        Assertions.assertThat((Object)testInstance).hasToString("Dispatcher to 666");
    }

    @Test
    void redirect_interfaceToObject_allMethodResultAreRedirectedToObject() {
        final ArrayList resultHolder = new ArrayList();
        EntryPoint surrogate1 = new EntryPoint(){

            @Override
            public NextStep doSomething() {
                resultHolder.add("something done");
                return null;
            }

            @Override
            public NextStep doSomethingElse() {
                resultHolder.add("something else done");
                return null;
            }
        };
        NextStep surrogate2 = new NextStep(){

            @Override
            public void doStepThing() {
                resultHolder.add("step thing done");
            }
        };
        EntryPoint testInstance = (EntryPoint)new MethodDispatcher().redirect(EntryPoint.class, (Object)surrogate1, (Object)surrogate2).build(EntryPoint.class);
        testInstance.doSomething().doStepThing();
        Assertions.assertThat(resultHolder).containsExactly((Object[])new String[]{"something done", "step thing done"});
    }

    @Test
    void build_noFallbackInstance_callingUnredirectedMethodThrowsException() {
        Holder2 testInstance = (Holder2)new MethodDispatcher().redirect(Hanger.class, (Object)new Hanger.Holder()).build(Holder2.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(testInstance::get).isInstanceOf(NullPointerException.class)).hasMessage("No fallback instance was declared, therefore calling j.u.f.Supplier.get() would throw NullPointerException: try to set one or redirect given method to a compatible instance");
    }

    @Test
    void redirect_whenInvokedMethodThrowsAnException_exceptionMustBeThrownWithoutWrapping() {
        MutableInt hanger = new MutableInt();
        Holder2 testInstance = (Holder2)new MethodDispatcher().redirect(Supplier.class, () -> "Hello world !").redirect(Hanger.class, arg_0 -> ((MutableInt)hanger).increment(arg_0)).build(Holder2.class);
        Assertions.assertThat((String)((String)testInstance.get())).isEqualTo("Hello world !");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.set("sqds")).isInstanceOf(MethodDispatcher.WrongTypeReturnedException.class)).hasMessage("Code handling o.c.t.f.Hanger.set(j.l.Object) is expected to return a j.l.Integer but returned a j.l.String");
    }

    @Test
    void redirect_whenFallbackInstanceDoesntSupportInvokedMethod_exceptionMustBeThrown() {
        Holder2 testInstance = (Holder2)new MethodDispatcher().fallbackOn((Object)"toto").build(Holder2.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(testInstance::get).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Wrong given instance");
    }

    @Test
    void redirect_targetClassDoesntImplementRedirectingClasses_exceptionIsThrown() {
        MethodDispatcher methodDispatcher = new MethodDispatcher().redirect(Supplier.class, () -> "Hello world !");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            CharSequence cfr_ignored_0 = (CharSequence)methodDispatcher.build(CharSequence.class);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(" doesn't implement ");
    }

    @Test
    void redirect_returnTypesAreNotThoseOfInterface_returnProxyIsAsked_works() {
        DummyFluentInterface testInstance = (DummyFluentInterface)new MethodDispatcher().redirect(SubclassAwareFluentInterface.class, (Object)new FluentInterfaceSupport(), true).build(DummyFluentInterface.class);
        Assertions.assertThatCode(() -> {
            DummyFluentInterface cfr_ignored_0 = (DummyFluentInterface)((DummyFluentInterface)testInstance.doSomething()).doSomethingElse();
        }).doesNotThrowAnyException();
    }

    @Test
    void redirect_returnTypesAreNotThoseOfInterface_returnProxyIsNotAsked_throwsException() {
        DummyFluentInterface testInstance = (DummyFluentInterface)new MethodDispatcher().redirect(SubclassAwareFluentInterface.class, (Object)new FluentInterfaceSupport()).build(DummyFluentInterface.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            DummyFluentInterface cfr_ignored_0 = (DummyFluentInterface)((DummyFluentInterface)testInstance.doSomething()).doSomethingElse();
        }).isInstanceOf(ClassCastException.class)).hasMessage("org.codefilarete.tool.reflect.MethodDispatcherTest$FluentInterfaceSupport cannot be cast to org.codefilarete.tool.reflect.MethodDispatcherTest$DummyFluentInterface");
    }

    @Test
    void redirect_proxyHasMultilpleInheritanceWithRefinedType() {
        SubclassNotAwareFluentInterfaceSupport testInstance = (SubclassNotAwareFluentInterfaceSupport)new MethodDispatcher().redirect(SubSubclassNotAwareFluentInterface.class, (Object)new SubSubclassNotAwareFluentInterface(){

            @Override
            public SubSubclassNotAwareFluentInterface doSomething() {
                return null;
            }

            @Override
            public SubSubclassNotAwareFluentInterface doSomethingElse() {
                return null;
            }

            @Override
            public SubSubclassNotAwareFluentInterface doEvenMore() {
                return null;
            }
        }, true).build(SubclassNotAwareFluentInterfaceSupport.class);
        Assertions.assertThatCode(() -> testInstance.doSomething().doSomethingElse().doEvenMore()).doesNotThrowAnyException();
    }

    @Test
    void redirect_proxyHasMultilpleInheritanceWithRefinedType2() {
        MultipleInheritanceTestSupport testInstance = (MultipleInheritanceTestSupport)new MethodDispatcher().redirect(SubclassNotAwareFluentInterface.class, (Object)new SubclassNotAwareFluentInterface(){

            @Override
            public SubclassNotAwareFluentInterface doSomething() {
                return null;
            }

            @Override
            public SubclassNotAwareFluentInterface doSomethingElse() {
                return null;
            }
        }, true).redirect(ASimpleContract.class, () -> {}, true).build(MultipleInheritanceTestSupport.class);
        Assertions.assertThatCode(() -> testInstance.doSomething().simpleContractMethod()).doesNotThrowAnyException();
    }

    @Test
    void redirect_givenClassHasSomeMethodsOutOfInterfaceScope_throwsException() {
        MethodDispatcher testInstance = new MethodDispatcher().redirect(String.class, (Object)"abc");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            CharSequence cfr_ignored_0 = (CharSequence)testInstance.build(CharSequence.class);
        }).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Cannot intercept concrete method");
    }

    private static interface NextStep {
        public void doStepThing();
    }

    private static interface EntryPoint {
        public NextStep doSomething();

        public NextStep doSomethingElse();
    }

    private static class IntegerHanger
    implements Hanger<Integer> {
        private final MutableInt hanger = new MutableInt();

        private IntegerHanger() {
        }

        public void set(Integer value) {
            this.hanger.increment(value.intValue());
        }

        public int getValue() {
            return this.hanger.getValue();
        }
    }

    private static interface MultipleInheritanceTestSupport
    extends SubclassNotAwareFluentInterface,
    ASimpleContract {
        @Override
        public MultipleInheritanceTestSupport doSomething();

        @Override
        public MultipleInheritanceTestSupport doSomethingElse();
    }

    private static interface ASimpleContract {
        public void simpleContractMethod();
    }

    private static interface SubclassNotAwareFluentInterfaceSupport
    extends SubclassNotAwareFluentInterface,
    SubSubclassNotAwareFluentInterface,
    ASimpleContract {
    }

    private static interface SubSubclassNotAwareFluentInterface
    extends SubclassNotAwareFluentInterface {
        @Override
        public SubSubclassNotAwareFluentInterface doSomething();

        @Override
        public SubSubclassNotAwareFluentInterface doSomethingElse();

        public SubSubclassNotAwareFluentInterface doEvenMore();
    }

    private static interface SubclassNotAwareFluentInterface {
        public SubclassNotAwareFluentInterface doSomething();

        public SubclassNotAwareFluentInterface doSomethingElse();
    }

    private static class FluentInterfaceSupport
    implements SubclassAwareFluentInterface {
        private FluentInterfaceSupport() {
        }

        public SubclassAwareFluentInterface doSomething() {
            return this;
        }

        public SubclassAwareFluentInterface doSomethingElse() {
            return this;
        }
    }

    private static interface DummyFluentInterface
    extends SubclassAwareFluentInterface<DummyFluentInterface> {
        public DummyFluentInterface doSpecialThing();
    }

    private static interface SubclassAwareFluentInterface<Z extends SubclassAwareFluentInterface<Z>> {
        public Z doSomething();

        public Z doSomethingElse();
    }

    private static interface Holder3
    extends AutoCloseable {
    }

    private static interface Holder2
    extends Supplier<String>,
    Hanger<String> {
    }

    private static interface Holder1
    extends Supplier<String>,
    Hanger<Integer> {
    }
}

