/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilteringIterator<T>
implements Iterator<T> {
    private final Iterator<T> delegate;
    private final Predicate<T> acceptFilter;
    private T lookAhead;
    private boolean hasMatcher;

    public FilteringIterator(Iterator<T> delegate, Predicate<T> acceptFilter) {
        this.delegate = delegate;
        this.acceptFilter = acceptFilter;
    }

    @Override
    public boolean hasNext() {
        this.consumeDelegateUntilMatch();
        return this.hasMatcher;
    }

    private void consumeDelegateUntilMatch() {
        while (!this.hasMatcher && this.delegate.hasNext()) {
            this.lookAhead = this.delegate.next();
            if (!this.acceptFilter.test(this.lookAhead)) continue;
            this.hasMatcher = true;
        }
    }

    @Override
    public T next() {
        if (!this.hasMatcher) {
            throw new NoSuchElementException();
        }
        this.hasMatcher = false;
        return this.lookAhead;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

