/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;

class StringsTest {
    StringsTest() {
    }

    @Test
    void isEmpty() {
        Assertions.assertThat((boolean)Strings.isEmpty((CharSequence)"a")).isFalse();
        Assertions.assertThat((boolean)Strings.isEmpty((CharSequence)"")).isTrue();
        Assertions.assertThat((boolean)Strings.isEmpty(null)).isTrue();
    }

    @Test
    void capitalize() {
        Assertions.assertThat((String)Strings.capitalize((CharSequence)"bonjour")).isEqualTo("Bonjour");
        Assertions.assertThat((String)Strings.capitalize((CharSequence)"BONJOUR")).isEqualTo("BONJOUR");
        Assertions.assertThat((String)Strings.capitalize((CharSequence)"")).isEqualTo("");
        Assertions.assertThat((String)Strings.capitalize(null)).isEqualTo(null);
    }

    @Test
    void head() {
        Assertions.assertThat((CharSequence)Strings.head((CharSequence)"snake", (int)2)).isEqualTo((Object)"sn");
        Assertions.assertThat((CharSequence)Strings.head((CharSequence)"snake", (int)3)).isEqualTo((Object)"sna");
        Assertions.assertThat((CharSequence)Strings.head((CharSequence)"snake", (int)42)).isEqualTo((Object)"snake");
        Assertions.assertThat((CharSequence)Strings.head(null, (int)2)).isEqualTo(null);
    }

    @Test
    void head_stringBoundary() {
        Assertions.assertThat((CharSequence)Strings.head((String)"snake", (String)"a")).isEqualTo((Object)"sn");
        Assertions.assertThat((CharSequence)Strings.head((String)"snake", (String)"k")).isEqualTo((Object)"sna");
        Assertions.assertThat((CharSequence)Strings.head((String)"snake", (String)"w")).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)Strings.head(null, (String)"z")).isEqualTo(null);
    }

    @Test
    void split() {
        Assertions.assertThat((List)Strings.split((String)"snake", (char)'a', (boolean)true)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"sna", "ke"}));
        Assertions.assertThat((List)Strings.split((String)"snake eye", (char)'e', (boolean)true)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"snake", " e", "ye"}));
        Assertions.assertThat((List)Strings.split((String)"snake", (char)'a', (boolean)false)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"sn", "ke"}));
        Assertions.assertThatCode(() -> Strings.split(null, (char)' ', (boolean)true)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void cutHead() {
        Assertions.assertThat((CharSequence)Strings.cutHead((CharSequence)"snake", (int)2)).isEqualTo((Object)"ake");
        Assertions.assertThat((CharSequence)Strings.cutHead((CharSequence)"snake", (int)3)).isEqualTo((Object)"ke");
        Assertions.assertThat((CharSequence)Strings.cutHead((CharSequence)"snake", (int)42)).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)Strings.cutHead(null, (int)2)).isEqualTo(null);
    }

    @Test
    void tail() {
        Assertions.assertThat((CharSequence)Strings.tail((CharSequence)"snake", (int)2)).isEqualTo((Object)"ke");
        Assertions.assertThat((CharSequence)Strings.tail((CharSequence)"snake", (int)3)).isEqualTo((Object)"ake");
        Assertions.assertThat((CharSequence)Strings.tail((CharSequence)"snake", (int)42)).isEqualTo((Object)"snake");
        Assertions.assertThat((CharSequence)Strings.tail(null, (int)2)).isEqualTo(null);
    }

    @Test
    void tail_stringBoundary() {
        Assertions.assertThat((CharSequence)Strings.tail((CharSequence)"snake", (String)"a")).isEqualTo((Object)"ke");
        Assertions.assertThat((CharSequence)Strings.tail((CharSequence)"snake", (String)"n")).isEqualTo((Object)"ake");
        Assertions.assertThat((CharSequence)Strings.tail((CharSequence)"snake", (String)"x")).isEqualTo((Object)"snake");
        Assertions.assertThat((CharSequence)Strings.tail(null, (String)"x")).isEqualTo(null);
    }

    @Test
    void cutTail() {
        Assertions.assertThat((CharSequence)Strings.cutTail((CharSequence)"snake", (int)2)).isEqualTo((Object)"sna");
        Assertions.assertThat((CharSequence)Strings.cutTail((CharSequence)"snake", (int)3)).isEqualTo((Object)"sn");
        Assertions.assertThat((CharSequence)Strings.cutTail((CharSequence)"snake", (int)42)).isEqualTo((Object)"");
        Assertions.assertThat((CharSequence)Strings.cutTail(null, (int)2)).isEqualTo(null);
    }

    @Test
    void ellipsis() {
        Assertions.assertThat((CharSequence)Strings.ellipsis((CharSequence)"a too long sentense", (int)10)).isEqualTo((Object)"a too long...");
        Assertions.assertThat((CharSequence)Strings.ellipsis((CharSequence)"0123456789", (int)10)).isEqualTo((Object)"0123456789");
        Assertions.assertThat((CharSequence)Strings.ellipsis((CharSequence)"a word", (int)10)).isEqualTo((Object)"a word");
        Assertions.assertThat((CharSequence)Strings.ellipsis(null, (int)10)).isEqualTo(null);
    }

    @Test
    void testRepeat() {
        String s10 = "aaaaaaaaaa";
        String s5 = "bbbbb";
        String s = "c";
        Assertions.assertThat((String)Strings.repeat((int)3, (CharSequence)s, (String[])new String[0]).toString()).isEqualTo("ccc");
        Assertions.assertThat((String)Strings.repeat((int)8, (CharSequence)s, (String[])new String[0]).toString()).isEqualTo("cccccccc");
        Assertions.assertThat((String)Strings.repeat((int)3, (CharSequence)s, (String[])new String[]{s10, s5}).toString()).isEqualTo("ccc");
        Assertions.assertThat((String)Strings.repeat((int)5, (CharSequence)s, (String[])new String[]{s10, s5}).toString()).isEqualTo("bbbbb");
        Assertions.assertThat((String)Strings.repeat((int)8, (CharSequence)s, (String[])new String[]{s10, s5}).toString()).isEqualTo("bbbbbccc");
        Assertions.assertThat((String)Strings.repeat((int)12, (CharSequence)s, (String[])new String[]{s10, s5}).toString()).isEqualTo("aaaaaaaaaacc");
        Assertions.assertThat((String)Strings.repeat((int)17, (CharSequence)s, (String[])new String[]{s10, s5}).toString()).isEqualTo("aaaaaaaaaabbbbbcc");
        Assertions.assertThat((String)Strings.repeat((int)27, (CharSequence)s, (String[])new String[]{s10, s5}).toString()).isEqualTo("aaaaaaaaaaaaaaaaaaaabbbbbcc");
        Assertions.assertThat((String)Strings.repeat((int)27, (CharSequence)s, (String[])new String[]{s5, s10}).toString()).isEqualTo("bbbbbbbbbbbbbbbbbbbbbbbbbcc");
    }

    @Test
    void footPrint() {
        Assertions.assertThat((String)Strings.footPrint((Object)new FootPrintCandidate().setValue1(42), (Function[])new Function[]{rec$ -> ((FootPrintCandidate)rec$).getValue1()})).isEqualTo("42");
        Assertions.assertThat((String)Strings.footPrint((Object)new FootPrintCandidate().setValue1(42).setValue2("a"), (Function[])new Function[]{rec$ -> ((FootPrintCandidate)rec$).getValue1(), rec$ -> ((FootPrintCandidate)rec$).getValue2()})).isEqualTo("42, a");
    }

    private class FootPrintCandidate {
        private int value1;
        private String value2;

        private FootPrintCandidate() {
        }

        private int getValue1() {
            return this.value1;
        }

        private FootPrintCandidate setValue1(int value1) {
            this.value1 = value1;
            return this;
        }

        private String getValue2() {
            return this.value2;
        }

        private FootPrintCandidate setValue2(String value2) {
            this.value2 = value2;
            return this;
        }
    }
}

