/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.junit.jupiter.api.Test;

class KeepOrderSetTest {
    KeepOrderSetTest() {
    }

    @Test
    void add_emptyConstructor() {
        KeepOrderSet testInstance = new KeepOrderSet();
        testInstance.add((Object)"g");
        Assertions.assertThat((List)Iterables.copy((Iterable)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"g"}));
    }

    @Test
    void add_notEmptyConstructor() {
        KeepOrderSet testInstance = new KeepOrderSet((Object[])new String[]{"b", "a"});
        testInstance.add((Object)"g");
        Assertions.assertThat((List)Iterables.copy((Iterable)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"b", "a", "g"}));
    }

    @Test
    void add_notEmptyConstructor_uniquenessIsMade() {
        KeepOrderSet testInstance = new KeepOrderSet((Object[])new String[]{"b", "a"});
        testInstance.add((Object)"b");
        Assertions.assertThat((List)Iterables.copy((Iterable)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"b", "a"}));
    }

    @Test
    void addAll_emptyConstructor() {
        KeepOrderSet testInstance = new KeepOrderSet();
        testInstance.addAll((Collection)Arrays.asList((Object[])new String[]{"g", "z", "q"}));
        Assertions.assertThat((List)Iterables.copy((Iterable)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"g", "z", "q"}));
    }

    @Test
    void addAll_notEmptyConstructor() {
        KeepOrderSet testInstance = new KeepOrderSet((Object[])new String[]{"b", "a"});
        testInstance.addAll((Collection)Arrays.asList((Object[])new String[]{"g", "z", "q"}));
        Assertions.assertThat((List)Iterables.copy((Iterable)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"b", "a", "g", "z", "q"}));
    }

    @Test
    void addAll_notEmptyConstructor_uniquenessIsAsserted() {
        KeepOrderSet testInstance = new KeepOrderSet((Object[])new String[]{"b", "a"});
        testInstance.addAll((Collection)Arrays.asList((Object[])new String[]{"a", "b", "q"}));
        Assertions.assertThat((List)Iterables.copy((Iterable)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"b", "a", "q"}));
    }

    @Test
    void size() {
        KeepOrderSet testInstance = new KeepOrderSet((Object[])new String[]{"b", "a"});
        Assertions.assertThat((int)testInstance.size()).isEqualTo(2);
        testInstance.addAll((Collection)Arrays.asList((Object[])new String[]{"a", "b", "q"}));
        Assertions.assertThat((int)testInstance.size()).isEqualTo(3);
    }

    @Test
    void contains() {
        KeepOrderSet testInstance = new KeepOrderSet((Object[])new String[]{"b", "a"});
        Assertions.assertThat((boolean)testInstance.contains((Object)"b")).isTrue();
        KeepOrderSet testInstance2 = new KeepOrderSet();
        Assertions.assertThat((boolean)testInstance2.contains((Object)"b")).isFalse();
        KeepOrderSet testInstance3 = new KeepOrderSet();
        Assertions.assertThat((boolean)testInstance3.contains((Object)"b")).isFalse();
    }

    @Test
    void remove() {
        KeepOrderSet testInstance = new KeepOrderSet((Object[])new String[]{"b", "a"});
        boolean removed = testInstance.remove((Object)"b");
        Assertions.assertThat((List)Iterables.copy((Iterable)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a"}));
        Assertions.assertThat((boolean)removed).isTrue();
        KeepOrderSet testInstance2 = new KeepOrderSet();
        boolean removed2 = testInstance2.remove((Object)"b");
        Assertions.assertThat((boolean)removed2).isFalse();
        KeepOrderSet testInstance3 = new KeepOrderSet();
        boolean removed3 = testInstance3.remove((Object)"b");
        Assertions.assertThat((boolean)removed3).isFalse();
    }

    @Test
    void getAt() {
        KeepOrderSet testInstance = new KeepOrderSet((Object[])new String[]{"b", "a"});
        Assertions.assertThat((String)((String)testInstance.getAt(0))).isEqualTo("b");
        Assertions.assertThat((String)((String)testInstance.getAt(1))).isEqualTo("a");
        KeepOrderSet testInstance2 = new KeepOrderSet();
        Assertions.assertThat((String)((String)testInstance2.getAt(1))).isNull();
    }

    @Test
    void removeAt() {
        KeepOrderSet testInstance = new KeepOrderSet((Object[])new String[]{"b", "a"});
        testInstance.removeAt(0);
        Assertions.assertThat((List)Iterables.copy((Iterable)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a"}));
        KeepOrderSet testInstance2 = new KeepOrderSet();
        testInstance2.removeAt(0);
    }
}

