/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.bean;

import java.lang.reflect.Field;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.bean.FieldIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class FieldIteratorTest {
    public static Object[][] testNextData() throws NoSuchFieldException {
        Field xf1 = X.class.getDeclaredField("f1");
        Field yf2 = Y.class.getDeclaredField("f2");
        Field zf2 = Z.class.getDeclaredField("f2");
        return new Object[][]{{X.class, Arrays.asList((Object[])new Field[]{xf1})}, {Y.class, Arrays.asList((Object[])new Field[]{yf2, xf1})}, {Z.class, Arrays.asList((Object[])new Field[]{zf2, yf2, xf1})}, {NoField.class, Arrays.asList((Object[])new Field[]{xf1})}};
    }

    @ParameterizedTest
    @MethodSource(value={"testNextData"})
    public void testNext(Class clazz, List<Field> expectedFields) {
        FieldIterator testInstance = new FieldIterator(clazz);
        Assertions.assertThat((List)Iterables.collectToList(() -> testInstance, Function.identity())).isEqualTo(expectedFields);
    }

    @Test
    public void testNext_throwsNoSuchElementException() {
        FieldIterator testInstance = new FieldIterator(X.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        testInstance.next();
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((FieldIterator)testInstance).next());
        testInstance = new FieldIterator(X.class);
        testInstance.next();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((FieldIterator)testInstance).next());
        testInstance = new FieldIterator(Object.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((FieldIterator)testInstance).next());
        testInstance = new FieldIterator(Object.class);
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((FieldIterator)testInstance).next());
    }

    static class NoField
    extends X {
        NoField() {
        }
    }

    static class Z
    extends Y {
        private Object f2;

        Z() {
        }
    }

    static class Y
    extends X {
        private Object f2;

        Y() {
        }
    }

    static class X {
        private Object f1;

        X() {
        }
    }
}

