/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.postgresql.statement.binder;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.postgresql.statement.binder.PostgreSQLParameterBinderRegistry;
import org.codefilarete.stalactite.sql.postgresql.statement.binder.PostgreSQLTypeMapping;
import org.codefilarete.stalactite.sql.postgresql.test.PostgreSQLDatabaseHelper;
import org.codefilarete.stalactite.sql.postgresql.test.PostgreSQLTestDataSourceSelector;
import org.codefilarete.stalactite.sql.statement.binder.AbstractParameterBindersITTest;
import org.codefilarete.stalactite.sql.statement.binder.InMemoryBlobSupport;
import org.codefilarete.stalactite.sql.test.DatabaseHelper;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PostgreSQLParameterBindersTest
extends AbstractParameterBindersITTest {
    private static final DataSource DATASOURCE = new PostgreSQLTestDataSourceSelector().giveDataSource();

    PostgreSQLParameterBindersTest() {
    }

    public DataSource giveDataSource() {
        return DATASOURCE;
    }

    protected DatabaseHelper giveDatabaseHelper() {
        return new PostgreSQLDatabaseHelper();
    }

    @BeforeEach
    protected void createParameterBinderRegistry() {
        this.parameterBinderRegistry = new PostgreSQLParameterBinderRegistry();
    }

    @BeforeEach
    protected void createJavaTypeToSqlTypeMapping() {
        this.javaTypeToSqlTypeMapping = new PostgreSQLTypeMapping();
    }

    @Test
    protected void blobBinder() throws SQLException {
        InMemoryBlobSupport blob = new InMemoryBlobSupport("Hello world !".getBytes());
        LinkedHashSet valuesToInsert = Arrays.asSet((Object[])new Blob[]{blob, null});
        Connection connection = this.connectionProvider.giveConnection();
        connection.setAutoCommit(false);
        Set databaseContent = this.insertAndSelect(Blob.class, valuesToInsert);
        Assertions.assertThat((Collection)PostgreSQLParameterBindersTest.convertBlobToString((Set)databaseContent)).isEqualTo((Object)Arrays.asSet((Object[])new String[]{null, "Hello world !"}));
        connection.rollback();
    }

    @Test
    protected void localDateTimeBinder() throws SQLException {
        LocalDateTime initialTime = LocalDateTime.of(2021, Month.JULY, 12, 4, 23, 35, 123456789);
        LocalDateTime comparisonTime = LocalDateTime.of(2021, Month.JULY, 12, 4, 23, 35, 123457000);
        Set databaseContent = this.insertAndSelect(LocalDateTime.class, Arrays.asSet((Object[])new LocalDateTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new LocalDateTime[]{null, comparisonTime}));
    }

    @Test
    protected void localTimeBinder() throws SQLException {
        LocalTime initialTime = LocalTime.of(4, 23, 35, 123456789);
        LocalTime comparisonTime = LocalTime.of(4, 23, 35, 123457000);
        Set databaseContent = this.insertAndSelect(LocalTime.class, Arrays.asSet((Object[])new LocalTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new LocalTime[]{null, comparisonTime}));
    }
}

