/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Collection;
import java.util.Set;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.KeepOrderSet;

public interface EntityMerger<C> {
    public RowTransformer<C> getRowTransformer();

    public Set<Selectable<?>> getSelectableColumns();

    public static class EntityMergerAdapter<C, T extends Table<T>>
    implements EntityMerger<C> {
        private Set<Column<T, ?>> selectableColumns;
        private RowTransformer<C> rowTransformer;

        public EntityMergerAdapter(EntityMapping<C, ?, T> delegate) {
            this.selectableColumns = new KeepOrderSet((Collection)delegate.getSelectableColumns());
            this.rowTransformer = delegate.getRowTransformer();
        }

        @Override
        public RowTransformer<C> getRowTransformer() {
            return this.rowTransformer;
        }

        @Override
        public Set<Selectable<?>> getSelectableColumns() {
            return this.selectableColumns;
        }
    }
}

