/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.cycle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.runtime.cycle.CycleLoadRuntimeContext;
import org.codefilarete.stalactite.engine.runtime.cycle.EntityRelationStorage;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.trace.MutableInt;

public abstract class AbstractCycleLoader<SRC, TRGT, TRGTID>
implements SelectListener<TRGT, TRGTID> {
    protected final EntityPersister<TRGT, TRGTID> targetPersister;
    protected final Map<String, CascadeConfigurationResult<SRC, TRGT>> relations = new HashMap<String, CascadeConfigurationResult<SRC, TRGT>>();
    protected final ThreadContext<CycleLoadRuntimeContext<SRC, TRGTID>> currentRuntimeContext = new ThreadContext<CycleLoadRuntimeContext>(CycleLoadRuntimeContext::new);
    @VisibleForTesting
    final ThreadContext<Set<TRGTID>> currentlyLoadedEntityIdsInCycle = new ThreadContext<Set>(HashSet::new);
    @VisibleForTesting
    final ThreadContext<MutableInt> currentCycleCount = new ThreadContext<MutableInt>(MutableInt::new);

    protected AbstractCycleLoader(EntityPersister<TRGT, TRGTID> targetPersister) {
        this.targetPersister = targetPersister;
    }

    public void addRelation(String relationIdentifier, CascadeConfigurationResult<SRC, TRGT> configurationResult) {
        this.relations.put(relationIdentifier, configurationResult);
    }

    public void beforeSelect(Iterable<TRGTID> ids) {
        this.currentCycleCount.get().increment();
    }

    public void afterSelect(Set<? extends TRGT> result) {
        Set<TRGTID> alreadyLoadedEntities = this.currentlyLoadedEntityIdsInCycle.get();
        result.forEach(entity -> alreadyLoadedEntities.add(this.targetPersister.getId(entity)));
        CycleLoadRuntimeContext<SRC, TRGTID> runtimeContext = this.currentRuntimeContext.get();
        this.currentRuntimeContext.remove();
        Set<TRGTID> identifiersToLoad = runtimeContext.giveIdentifiersToLoad();
        identifiersToLoad.removeAll(alreadyLoadedEntities);
        if (!identifiersToLoad.isEmpty()) {
            Set targets = this.targetPersister.select(identifiersToLoad);
            Map targetPerId = Iterables.map((Iterable)targets, arg_0 -> this.targetPersister.getId(arg_0));
            this.relations.forEach((relationName, configurationResult) -> {
                EntityRelationStorage targetIdsPerSource = runtimeContext.getEntitiesToFulFill((String)relationName);
                if (targetIdsPerSource != null) {
                    this.applyRelationToSource(targetIdsPerSource, configurationResult.getBeanRelationFixer(), targetPerId);
                }
            });
        }
        if (this.currentCycleCount.get().decrement() == 0) {
            this.currentlyLoadedEntityIdsInCycle.remove();
            this.currentRuntimeContext.remove();
            this.currentCycleCount.remove();
        }
    }

    protected abstract void applyRelationToSource(EntityRelationStorage<SRC, TRGTID> var1, BeanRelationFixer<SRC, TRGT> var2, Map<TRGTID, TRGT> var3);

    public void onSelectError(Iterable<TRGTID> ids, RuntimeException exception) {
        this.currentRuntimeContext.remove();
        throw exception;
    }

    @VisibleForTesting
    static class ThreadContext<T> {
        private final ThreadLocal<T> store = new ThreadLocal();
        private final Supplier<T> valueInitializer;

        public ThreadContext() {
            this(null);
        }

        public ThreadContext(Supplier<T> valueInitializer) {
            this.valueInitializer = valueInitializer;
        }

        protected void set(T t) {
            this.store.set(t);
        }

        public T get() {
            if (!this.isPresent() && this.valueInitializer != null) {
                this.store.set(this.valueInitializer.get());
            }
            return this.store.get();
        }

        public boolean isPresent() {
            return this.store.get() != null;
        }

        public void remove() {
            this.store.remove();
        }
    }
}

