/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetomany;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.onetomany.FirstPhaseCycleLoadListener;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyAssociationConfiguration;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyConfigurerTemplate;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelation;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.onetomany.IndexedMappedManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.MappedManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithIndexedMappedAssociationEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithMappedAssociationEngine;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.Maps;

class OneToManyWithMappedAssociationConfigurer<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>>
extends OneToManyConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, C, LEFTTABLE> {
    private OneToManyWithMappedAssociationEngine<SRC, TRGT, SRCID, TRGTID, C, RIGHTTABLE> mappedAssociationEngine;
    private Key<RIGHTTABLE, SRCID> foreignKey;
    private Set<Column<RIGHTTABLE, ?>> mappedReverseColumns;
    private Function<SRCID, Map<Column<RIGHTTABLE, ?>, ?>> reverseColumnsValueProvider;

    OneToManyWithMappedAssociationConfigurer(OneToManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C, LEFTTABLE> associationConfiguration, boolean loadSeparately) {
        super(associationConfiguration, loadSeparately);
    }

    @Override
    protected String configure(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        this.determineForeignKeyColumns(targetPersister);
        this.assignAssociationEngine(targetPersister);
        this.propagateMappedAssociationToSubTables(targetPersister);
        String relationJoinNodeName = this.mappedAssociationEngine.addSelectCascade(this.associationConfiguration.getLeftPrimaryKey(), this.loadSeparately);
        this.addWriteCascades(this.mappedAssociationEngine, targetPersister);
        return relationJoinNodeName;
    }

    public void propagateMappedAssociationToSubTables(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        ForeignKeyNamingStrategy foreignKeyNamingStrategy = this.associationConfiguration.getForeignKeyNamingStrategy();
        if (!this.associationConfiguration.getOneToManyRelation().isSourceTablePerClassPolymorphic()) {
            AbstractPolymorphismPersister<TRGT, TRGT> targetPersisterAsPolymorphic = AbstractPolymorphismPersister.lookupForPolymorphicPersister(targetPersister);
            if (targetPersisterAsPolymorphic == null) {
                targetPersister.getMainTable().addForeignKey(foreignKeyNamingStrategy::giveName, this.foreignKey, (Key)this.associationConfiguration.getSrcPersister().getMainTable().getPrimaryKey());
            } else {
                targetPersisterAsPolymorphic.propagateMappedAssociationToSubTables(this.foreignKey, this.associationConfiguration.getSrcPersister().getMainTable().getPrimaryKey(), foreignKeyNamingStrategy::giveName);
            }
        }
    }

    protected void determineForeignKeyColumns(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        Object mainTargetTable = targetPersister.getMainTable();
        Key.KeyBuilder foreignKeyBuilder = Key.from(mainTargetTable);
        OneToManyRelation relation = this.associationConfiguration.getOneToManyRelation();
        if (!relation.getForeignKeyNameMapping().isEmpty()) {
            HashMap foreignKeyColumnMapping = new HashMap();
            relation.getForeignKeyNameMapping().forEach((valueAccessPoint, colName) -> {
                Accessor accessor;
                AccessorDefinition localAccessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint);
                Object object = valueAccessPoint instanceof Accessor ? (Accessor)valueAccessPoint : (accessor = valueAccessPoint instanceof ReversibleMutator ? ((ReversibleMutator)valueAccessPoint).toAccessor() : null);
                if (accessor == null) {
                    throw new UnsupportedOperationException("Can't get accessor from " + valueAccessPoint);
                }
                Column column = mainTargetTable.addColumn(colName, localAccessorDefinition.getMemberType());
                foreignKeyBuilder.addColumn((JoinLink)column);
                foreignKeyColumnMapping.put(accessor, column);
            });
            this.mappedReverseColumns = new KeepOrderSet(foreignKeyColumnMapping.values());
            this.reverseColumnsValueProvider = srcid -> {
                HashMap result = new HashMap();
                foreignKeyColumnMapping.forEach((accessor, column) -> result.put(column, accessor.get(srcid)));
                return result;
            };
        } else if (!relation.getForeignKeyColumnMapping().isEmpty()) {
            HashMap foreignKeyColumnMapping = new HashMap();
            relation.getForeignKeyColumnMapping().forEach((valueAccessPoint, column) -> {
                Accessor accessor;
                Object object = valueAccessPoint instanceof Accessor ? (Accessor)valueAccessPoint : (accessor = valueAccessPoint instanceof ReversibleMutator ? ((ReversibleMutator)valueAccessPoint).toAccessor() : null);
                if (accessor == null) {
                    throw new UnsupportedOperationException("Can't get accessor from " + valueAccessPoint);
                }
                foreignKeyBuilder.addColumn((JoinLink)column);
                foreignKeyColumnMapping.put(accessor, column);
            });
            this.mappedReverseColumns = new KeepOrderSet(foreignKeyColumnMapping.values());
            this.reverseColumnsValueProvider = srcid -> {
                HashMap result = new HashMap();
                foreignKeyColumnMapping.forEach((accessor, column) -> result.put(column, accessor.get(srcid)));
                return result;
            };
        } else if (relation.getReverseColumnName() != null || relation.getReverseColumn() != null) {
            Column reverseColumn;
            if (relation.getReverseColumnName() != null) {
                PrimaryKey srcPrimaryKey = this.associationConfiguration.getSrcPersister().getMainTable().getPrimaryKey();
                if (srcPrimaryKey.isComposed()) {
                    throw new MappingConfigurationException("Giving reverse column whereas the primary key is composed : primary key = [" + srcPrimaryKey.getColumns().stream().map(Column::getName).collect(Collectors.joining(", ")) + "] vs  reverse column = " + relation.getReverseColumnName());
                }
                Column pk = (Column)Iterables.first((Iterable)srcPrimaryKey.getColumns());
                reverseColumn = mainTargetTable.addColumn(relation.getReverseColumnName(), pk.getJavaType(), pk.getSize());
            } else {
                reverseColumn = relation.getReverseColumn();
            }
            foreignKeyBuilder.addColumn(reverseColumn);
            this.mappedReverseColumns = new KeepOrderSet((Object[])new Column[]{reverseColumn});
            this.reverseColumnsValueProvider = srcid -> {
                HashMap<Column, Object> result = new HashMap<Column, Object>();
                result.put(reverseColumn, srcid);
                return result;
            };
        } else if (relation.giveReverseSetter() != null) {
            HashMap foreignKeyColumnMapping = new HashMap();
            PrimaryKey primaryKey = this.associationConfiguration.getSrcPersister().getMainTable().getPrimaryKey();
            AccessorDefinition reverseGetterDefinition = AccessorDefinition.giveDefinition(relation.giveReverseSetter());
            primaryKey.getColumns().forEach(pkColumn -> {
                String colName = this.associationConfiguration.getJoinColumnNamingStrategy().giveName(reverseGetterDefinition, (Column<?, ?>)pkColumn);
                Column fkColumn = mainTargetTable.addColumn(colName, pkColumn.getJavaType(), pkColumn.getSize(), null);
                foreignKeyBuilder.addColumn((JoinLink)fkColumn);
                foreignKeyColumnMapping.put(pkColumn, fkColumn);
            });
            this.mappedReverseColumns = new KeepOrderSet(foreignKeyColumnMapping.values());
            this.reverseColumnsValueProvider = srcid -> {
                IdentifierAssembler identifierAssembler = this.associationConfiguration.getSrcPersister().getMapping().getIdMapping().getIdentifierAssembler();
                Map columnValues = identifierAssembler.getColumnValues(srcid);
                return Maps.innerJoin((Map)foreignKeyColumnMapping, (Map)columnValues);
            };
        }
        this.foreignKey = foreignKeyBuilder.build();
        if (relation.isReverseAsMandatory() != null && relation.isReverseAsMandatory().booleanValue()) {
            this.foreignKey.getColumns().stream().map(Column.class::cast).forEach(Column::notNull);
        }
    }

    void assignAssociationEngine(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        BiConsumer<Object, Object> reverseSetterAsConsumer;
        Mutator reversePropertyAccessor = null;
        if (this.associationConfiguration.getOneToManyRelation().giveReverseSetter() != null) {
            reversePropertyAccessor = this.associationConfiguration.getOneToManyRelation().giveReverseSetter();
        }
        BiConsumer<Object, Object> biConsumer = reverseSetterAsConsumer = reversePropertyAccessor == null ? null : (arg_0, arg_1) -> reversePropertyAccessor.set(arg_0, arg_1);
        if (this.associationConfiguration.getOneToManyRelation().isOrdered()) {
            this.assignEngineForIndexedAssociation(reverseSetterAsConsumer, this.foreignKey, this.associationConfiguration.getOneToManyRelation().getIndexingColumn(), targetPersister);
        } else {
            this.assignEngineForNonIndexedAssociation(this.foreignKey, targetPersister, reverseSetterAsConsumer);
        }
    }

    @Override
    public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        this.determineForeignKeyColumns(targetPersister);
        this.assignAssociationEngine(targetPersister);
        this.mappedAssociationEngine.addSelectIn2Phases(this.associationConfiguration.getLeftPrimaryKey(), this.mappedAssociationEngine.getManyRelationDescriptor().getReverseColumn(), this.associationConfiguration.getCollectionGetter(), firstPhaseCycleLoadListener);
        this.addWriteCascades(this.mappedAssociationEngine, targetPersister);
        return new CascadeConfigurationResult(this.mappedAssociationEngine.getManyRelationDescriptor().getRelationFixer(), this.associationConfiguration.getSrcPersister());
    }

    private void addWriteCascades(OneToManyWithMappedAssociationEngine<SRC, TRGT, SRCID, TRGTID, C, RIGHTTABLE> mappedAssociationEngine, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        if (this.associationConfiguration.isWriteAuthorized()) {
            mappedAssociationEngine.addInsertCascade(targetPersister);
            mappedAssociationEngine.addUpdateCascade(this.associationConfiguration.isOrphanRemoval(), targetPersister);
            mappedAssociationEngine.addDeleteCascade(this.associationConfiguration.isOrphanRemoval(), targetPersister);
        }
    }

    private void assignEngineForNonIndexedAssociation(Key<?, SRCID> reverseColumn, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, @javax.annotation.Nullable BiConsumer<TRGT, SRC> reverseSetter) {
        MappedManyRelationDescriptor<Object, TRGT, Collection, SRCID> manyRelationDefinition = new MappedManyRelationDescriptor<Object, TRGT, Collection, SRCID>((Accessor<Object, Collection>)this.associationConfiguration.getCollectionGetter(), (arg_0, arg_1) -> this.associationConfiguration.getSetter().set(arg_0, arg_1), (Supplier<Collection>)this.associationConfiguration.getCollectionFactory(), reverseSetter, reverseColumn);
        this.mappedAssociationEngine = new OneToManyWithMappedAssociationEngine<Object, TRGT, SRCID, TRGTID, Collection, RIGHTTABLE>(targetPersister, manyRelationDefinition, this.associationConfiguration.getSrcPersister(), this.mappedReverseColumns, this.reverseColumnsValueProvider);
    }

    private void assignEngineForIndexedAssociation(@javax.annotation.Nullable BiConsumer<TRGT, SRC> reverseSetter, Key<?, SRCID> reverseColumn, @javax.annotation.Nullable Column<RIGHTTABLE, Integer> indexingColumn, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        if (indexingColumn == null) {
            String indexingColumnName = (String)Nullable.nullable((Object)this.associationConfiguration.getIndexingColumnName()).getOr(() -> this.associationConfiguration.getIndexColumnNamingStrategy().giveName(this.accessorDefinitionForTableNaming));
            Class<Integer> indexColumnType = this.associationConfiguration.isOrphanRemoval() ? Integer.TYPE : Integer.class;
            indexingColumn = targetPersister.getMapping().getTargetTable().addColumn(indexingColumnName, indexColumnType);
        }
        IndexedMappedManyRelationDescriptor<Object, Object, Collection, Object, Object> manyRelationDefinition = new IndexedMappedManyRelationDescriptor<Object, Object, Collection, Object, Object>((Accessor<Object, Collection>)this.associationConfiguration.getCollectionGetter(), (arg_0, arg_1) -> this.associationConfiguration.getSetter().set(arg_0, arg_1), this.associationConfiguration.getCollectionFactory(), (BiConsumer<Object, Object>)reverseSetter, (Key<?, Object>)reverseColumn, (Column<Table, Integer>)((Column<? extends Table, Integer>)indexingColumn), arg_0 -> this.associationConfiguration.getSrcPersister().getId(arg_0), arg_0 -> targetPersister.getId(arg_0));
        this.mappedAssociationEngine = new OneToManyWithIndexedMappedAssociationEngine<Object, Object, Object, Object, Collection, RIGHTTABLE>(targetPersister, manyRelationDefinition, this.associationConfiguration.getSrcPersister(), this.mappedReverseColumns, indexingColumn, this.reverseColumnsValueProvider);
    }
}

