/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.cascade;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Predicates;

public class BeforeDeleteSupport<TRIGGER, TARGET>
implements DeleteListener<TRIGGER> {
    private final Consumer<Iterable<TARGET>> beforeDeleteAction;
    private final Function<TRIGGER, TARGET> targetProvider;
    private final Predicate<TARGET> targetFilter;

    public BeforeDeleteSupport(Consumer<Iterable<TARGET>> beforeDeleteAction, Function<TRIGGER, TARGET> targetProvider) {
        this(beforeDeleteAction, targetProvider, Predicates.acceptAll());
    }

    public BeforeDeleteSupport(Consumer<Iterable<TARGET>> beforeDeleteAction, Function<TRIGGER, TARGET> targetProvider, Predicate<TARGET> targetFilter) {
        this.beforeDeleteAction = beforeDeleteAction;
        this.targetProvider = targetProvider;
        this.targetFilter = targetFilter;
    }

    public void beforeDelete(Iterable<? extends TRIGGER> entities) {
        this.beforeDeleteAction.accept(Iterables.stream(entities).map(this.targetProvider).filter(this.targetFilter).collect(Collectors.toList()));
    }
}

