/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.cascade;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Predicates;

public class BeforeDeleteByIdSupport<TRIGGER, TARGET>
implements DeleteByIdListener<TRIGGER> {
    private final Consumer<Iterable<TARGET>> beforeDeleteAction;
    private final Function<TRIGGER, TARGET> targetProvider;
    private final Predicate<TARGET> targetFilter;

    public BeforeDeleteByIdSupport(Consumer<Iterable<TARGET>> beforeDeleteAction, Function<TRIGGER, TARGET> targetProvider) {
        this(beforeDeleteAction, targetProvider, Predicates.acceptAll());
    }

    public BeforeDeleteByIdSupport(Consumer<Iterable<TARGET>> beforeDeleteAction, Function<TRIGGER, TARGET> targetProvider, Predicate<TARGET> targetFilter) {
        this.beforeDeleteAction = beforeDeleteAction;
        this.targetProvider = targetProvider;
        this.targetFilter = targetFilter;
    }

    public void beforeDeleteById(Iterable<? extends TRIGGER> entities) {
        this.beforeDeleteAction.accept(Iterables.stream(entities).map(this.targetProvider).filter(this.targetFilter).collect(Collectors.toList()));
    }
}

