/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.model.compositekey;

import java.util.Objects;
import java.util.Set;
import org.codefilarete.stalactite.engine.model.compositekey.House;
import org.codefilarete.stalactite.engine.model.compositekey.Pet;
import org.codefilarete.tool.collection.KeepOrderSet;

public class Person {
    private PersonId id;
    private int age;
    private House house;
    private Set<Pet> pets = new KeepOrderSet();

    public Person() {
    }

    public Person(PersonId id) {
        this.id = id;
    }

    public PersonId getId() {
        return this.id;
    }

    public void setId(PersonId id) {
        this.id = id;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public House getHouse() {
        return this.house;
    }

    public void setHouse(House house) {
        this.house = house;
    }

    public Set<Pet> getPets() {
        return this.pets;
    }

    public void addPet(Pet pet) {
        this.pets.add(pet);
    }

    public void removePet(Pet.PetId petId) {
        this.pets.removeIf(pet -> pet.getId().equals(petId));
    }

    public String toString() {
        return "Person{id=" + this.id + ", age=" + this.age + ", house=" + this.house + ", pets=" + this.pets + '}';
    }

    public static class PersonId {
        private String firstName;
        private String lastName;
        private String address;

        public PersonId() {
        }

        public PersonId(String firstName, String lastName, String address) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.address = address;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getFamilyName() {
            return this.lastName;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersonId personId = (PersonId)o;
            return Objects.equals(this.firstName, personId.firstName) && Objects.equals(this.lastName, personId.lastName) && Objects.equals(this.address, personId.address);
        }

        public int hashCode() {
            return Objects.hash(this.firstName, this.lastName, this.address);
        }

        public String toString() {
            return "PersonId{firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", address='" + this.address + '\'' + '}';
        }
    }
}

