/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Engine;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;

public class Vehicle
extends AbstractVehicle {
    private Color color;
    private Engine engine;
    private Person owner;
    private List<Wheel> wheels = new ArrayList<Wheel>();

    public Vehicle(Long id) {
        this(new PersistableIdentifier<Long>(id));
    }

    public Vehicle(Identifier<Long> id) {
        super(id);
    }

    public Vehicle() {
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Person getOwner() {
        return this.owner;
    }

    public void setOwner(Person owner) {
        this.owner = owner;
    }

    public List<Wheel> getWheels() {
        return this.wheels;
    }

    public void setWheels(List<Wheel> wheels) {
        this.wheels = wheels;
    }

    public void addWheel(Wheel wheel) {
        this.wheels.add(wheel);
        wheel.setVehicle(this);
    }

    public static class Wheel {
        private String serialNumber;
        private String model;
        private Vehicle vehicle;
        private boolean persisted;

        private Wheel() {
        }

        public Wheel(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }

        public String getModel() {
            return this.model;
        }

        public Wheel setModel(String model) {
            this.model = model;
            return this;
        }

        public Vehicle getVehicle() {
            return this.vehicle;
        }

        public void setVehicle(Vehicle vehicle) {
            this.vehicle = vehicle;
        }

        public boolean isPersisted() {
            return this.persisted;
        }

        public void markAsPersisted() {
            this.persisted = true;
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

