/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.entity.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.TableNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.UniqueConstraintNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.builder.InheritanceMappingStep;
import org.codefilarete.stalactite.engine.configurer.builder.TableMappingStep;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Car;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;

class InheritanceMappingStepTest {
    InheritanceMappingStepTest() {
    }

    @Test
    void collectEmbeddedMappingFromInheritance_fromMappedSuperClasses() {
        InheritanceMappingStep testInstance = new InheritanceMappingStep();
        Table dummyTable = new Table("Car");
        FluentEntityMappingBuilder entityMappingBuilder = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Car::getModel).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(AbstractVehicle.class).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)));
        EntityMappingConfiguration configuration = entityMappingBuilder.getConfiguration();
        InheritanceMappingStep.MappingPerTable mappingPerTable = testInstance.collectPropertiesMappingFromInheritance(configuration, new TableMappingStep().mapEntityConfigurationToTable(configuration, dummyTable, TableNamingStrategy.DEFAULT), new ColumnBinderRegistry(), ColumnNamingStrategy.DEFAULT, UniqueConstraintNamingStrategy.DEFAULT);
        ArrayList expected = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Car::getModel), (Mutator)Accessors.mutatorByField(Car.class, (String)"model")), (Object)dummyTable.getColumn("model")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getCreationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("creationDate")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getModificationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("modificationDate")).entrySet());
        expected.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ArrayList actual = new ArrayList(mappingPerTable.giveMapping(dummyTable).entrySet());
        actual.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actual).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expected);
    }

    @Test
    void collectEmbeddedMappingFromInheritance_fromInheritedClasses() {
        InheritanceMappingStep testInstance = new InheritanceMappingStep();
        FluentEntityMappingBuilder.FluentMappingBuilderInheritanceOptions entityMappingBuilder = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)));
        Table dummyTable = new Table("Car");
        EntityMappingConfiguration configuration = entityMappingBuilder.getConfiguration();
        InheritanceMappingStep.MappingPerTable mappingPerTable = testInstance.collectPropertiesMappingFromInheritance(configuration, new TableMappingStep().mapEntityConfigurationToTable(configuration, dummyTable, TableNamingStrategy.DEFAULT), new ColumnBinderRegistry(), ColumnNamingStrategy.DEFAULT, UniqueConstraintNamingStrategy.DEFAULT);
        ArrayList expected = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Car::getModel), (Mutator)Accessors.mutatorByField(Car.class, (String)"model")), (Object)dummyTable.getColumn("model")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getCreationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("creationDate")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getModificationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("modificationDate")).entrySet());
        expected.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        Assertions.assertThat((Collection)mappingPerTable.giveTables()).extracting(Table::getAbsoluteName).containsExactly((Object[])new String[]{"Car"});
        ArrayList actual = new ArrayList(mappingPerTable.giveMapping(dummyTable).entrySet());
        actual.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actual).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expected);
    }

    @Test
    void collectEmbeddedMappingFromInheritance_fromInheritedClasses_withJoinedTables() {
        Table carTable = new Table("Car");
        Table vehicleTable = new Table("Vehicle");
        Table abstractVehicleTable = new Table("AbstractVehicle");
        InheritanceMappingStep testInstance = new InheritanceMappingStep();
        FluentEntityMappingBuilder.FluentMappingBuilderInheritanceOptions entityMappingBuilder = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).embed(Vehicle::getColor, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Color.class).map(Color::getRgb)).mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate))).withJoinedTable()).withJoinedTable(vehicleTable);
        EntityMappingConfiguration configuration = entityMappingBuilder.getConfiguration();
        InheritanceMappingStep.MappingPerTable mappingPerTable = testInstance.collectPropertiesMappingFromInheritance(configuration, new TableMappingStep().mapEntityConfigurationToTable(configuration, carTable, TableNamingStrategy.DEFAULT), new ColumnBinderRegistry(), ColumnNamingStrategy.DEFAULT, UniqueConstraintNamingStrategy.DEFAULT);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)mappingPerTable.giveTables()).usingElementComparator(Comparator.comparing(Table::getAbsoluteName))).containsExactly((Object[])new Table[]{carTable, vehicleTable, abstractVehicleTable});
        ArrayList expectedCarMapping = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Car::getModel), (Mutator)Accessors.mutatorByField(Car.class, (String)"model")), (Object)carTable.getColumn("model")).entrySet());
        expectedCarMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ArrayList actualCarMapping = new ArrayList(mappingPerTable.giveMapping(carTable).entrySet());
        actualCarMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actualCarMapping).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expectedCarMapping);
        ArrayList expectedVehicleMapping = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Vehicle::getColor), (Mutator)Accessors.mutatorByMethodReference(Vehicle::setColor)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Color::getRgb), (Mutator)Accessors.mutatorByField(Color.class, (String)"rgb"))}), (Object)vehicleTable.getColumn("rgb")).entrySet());
        expectedVehicleMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ArrayList actualVehicleMapping = new ArrayList(mappingPerTable.giveMapping(vehicleTable).entrySet());
        actualVehicleMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actualVehicleMapping).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expectedVehicleMapping);
        abstractVehicleTable = (Table)Iterables.find((Iterable)mappingPerTable.giveTables(), table -> table.getName().equalsIgnoreCase("AbstractVehicle"));
        ArrayList expectedAbstractVehicleMapping = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getCreationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)abstractVehicleTable.getColumn("creationDate")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getModificationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setModificationDate))}), (Object)abstractVehicleTable.getColumn("modificationDate")).entrySet());
        expectedAbstractVehicleMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ArrayList actualAbstractVehicleMapping = new ArrayList(mappingPerTable.giveMapping(abstractVehicleTable).entrySet());
        actualAbstractVehicleMapping.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actualAbstractVehicleMapping).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expectedAbstractVehicleMapping);
    }

    @Test
    void collectEmbeddedMappingFromInheritance_withoutHierarchy() {
        InheritanceMappingStep testInstance = new InheritanceMappingStep();
        FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions entityMappingBuilder = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Car::getModel).embed(AbstractVehicle::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
        Table dummyTable = new Table("Car");
        EntityMappingConfiguration configuration = entityMappingBuilder.getConfiguration();
        InheritanceMappingStep.MappingPerTable mappingPerTable = testInstance.collectPropertiesMappingFromInheritance(configuration, new TableMappingStep().mapEntityConfigurationToTable(configuration, dummyTable, TableNamingStrategy.DEFAULT), new ColumnBinderRegistry(), ColumnNamingStrategy.DEFAULT, UniqueConstraintNamingStrategy.DEFAULT);
        ArrayList expected = new ArrayList(Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Car::getModel), (Mutator)Accessors.mutatorByField(Car.class, (String)"model")), (Object)dummyTable.getColumn("model")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getCreationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("creationDate")).add((Object)new AccessorChain(new Accessor[]{new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(AbstractVehicle::getTimestamp), (Mutator)Accessors.mutatorByMethodReference(AbstractVehicle::setTimestamp)), new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Timestamp::getModificationDate), (Mutator)Accessors.mutatorByMethodReference(Timestamp::setCreationDate))}), (Object)dummyTable.getColumn("modificationDate")).entrySet());
        expected.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ArrayList actual = new ArrayList(mappingPerTable.giveMapping(dummyTable).entrySet());
        actual.sort((e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.toString(), e2.toString()));
        ((ListAssert)Assertions.assertThat(actual).usingElementComparator(Comparator.comparing(Object::toString))).isEqualTo(expected);
    }
}

