/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.builder.IdentificationStep;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class IdentificationStepTest {
    IdentificationStepTest() {
    }

    @Test
    void assertCompositeKeyIdentifierOverridesEqualsHashcode() throws NoSuchFieldException {
        EntityMappingConfiguration.CompositeKeyMapping compositeKeyMappingMock = (EntityMappingConfiguration.CompositeKeyMapping)Mockito.mock(EntityMappingConfiguration.CompositeKeyMapping.class, (Answer)Mockito.RETURNS_MOCKS);
        class DummyEntity {
            private 1DummyCompositeKeyIdentifier dummyCompositeKeyIdentifier;
            private 1DummyCompositeKeyIdentifierWithEqualsAndHashCode dummyCompositeKeyIdentifierWithEqualsAndHashCode;

            DummyEntity() {
            }
        }
        Mockito.when((Object)compositeKeyMappingMock.getAccessor()).thenReturn((Object)new AccessorByField(DummyEntity.class.getDeclaredField("dummyCompositeKeyIdentifier")));
        Assertions.assertThatCode(() -> IdentificationStep.assertCompositeKeyIdentifierOverridesEqualsHashcode((EntityMappingConfiguration.CompositeKeyMapping)compositeKeyMappingMock)).hasMessage("Composite key identifier class o.c.s.e.c.b.IdentificationStepTest$DummyCompositeKeyIdentifier seems to have default implementation of equals() and hashcode() methods, which is not supported (identifiers must be distinguishable), please make it implement them");
        Mockito.when((Object)compositeKeyMappingMock.getAccessor()).thenReturn((Object)new AccessorByField(DummyEntity.class.getDeclaredField("dummyCompositeKeyIdentifierWithEqualsAndHashCode")));
        Assertions.assertThatCode(() -> IdentificationStep.assertCompositeKeyIdentifierOverridesEqualsHashcode((EntityMappingConfiguration.CompositeKeyMapping)compositeKeyMappingMock)).doesNotThrowAnyException();
    }
}

