/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.util.function.Function;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;

public class ToStringBuilder<E> {
    private final String separator;
    private final KeepOrderSet<Function<E, String>> mappers = new KeepOrderSet();

    @SafeVarargs
    public static <E> Function<E, String> of(String separator, Function<E, String> ... properties) {
        ToStringBuilder<E> result = new ToStringBuilder<E>(separator);
        for (Function<E, String> property : properties) {
            result.with(property);
        }
        return result::toString;
    }

    public static <E> Function<? extends Iterable<E>, String> asSeveral(final Function<E, String> mapper) {
        return coll -> new StringAppender(){

            public StringAppender cat(Object s) {
                return super.cat(s instanceof String ? s : mapper.apply(s));
            }
        }.ccat(coll, (Object)"").wrap((Object)"{", (Object)"}").toString();
    }

    private ToStringBuilder(String separator) {
        this.separator = separator;
    }

    ToStringBuilder<E> with(Function<E, String> mapper) {
        this.mappers.add(mapper);
        return this;
    }

    String toString(E object) {
        return new StringAppender().ccat((Iterable)Iterables.collectToList(this.mappers, m -> (String)m.apply(object)), (Object)this.separator).toString();
    }
}

