/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.ddl.DDLProvider;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Index;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.ddl.structure.UniqueConstraint;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.KeepOrderSet;

public class DDLGenerator
implements DDLProvider {
    private Set<Table<?>> tables = new KeepOrderSet();
    private Set<Sequence> sequences = new KeepOrderSet();
    private Set<DDLProvider> ddlProviders = new KeepOrderSet();
    private final DDLTableGenerator ddlTableGenerator;
    private final DDLSequenceGenerator ddlSequenceGenerator;

    public DDLGenerator(SqlTypeRegistry sqlTypeRegistry, DMLNameProviderFactory dmlNameProviderFactory) {
        this.ddlTableGenerator = new DDLTableGenerator(sqlTypeRegistry, dmlNameProviderFactory);
        this.ddlSequenceGenerator = new DDLSequenceGenerator(dmlNameProviderFactory);
    }

    public DDLGenerator(DDLTableGenerator ddlTableGenerator, DDLSequenceGenerator ddlSequenceGenerator) {
        this.ddlTableGenerator = ddlTableGenerator;
        this.ddlSequenceGenerator = ddlSequenceGenerator;
    }

    public DDLTableGenerator getDdlTableGenerator() {
        return this.ddlTableGenerator;
    }

    public void setTables(Set<? extends Table<?>> tables) {
        this.tables = tables;
    }

    public void addTables(Collection<? extends Table<?>> tables) {
        this.tables.addAll(tables);
    }

    public void addTables(Table<?> table, Table<?> ... tables) {
        this.tables.add(table);
        this.tables.addAll(Arrays.asList(tables));
    }

    public void setSequences(Set<Sequence> sequences) {
        this.sequences = sequences;
    }

    public void addSequences(Sequence sequence, Sequence ... sequences) {
        this.sequences.add(sequence);
        this.sequences.addAll(Arrays.asList(sequences));
    }

    public void addSequences(Collection<? extends Sequence> sequences) {
        this.sequences.addAll(sequences);
    }

    public void setDDLProviders(Set<DDLProvider> ddlParticipants) {
        this.ddlProviders = ddlParticipants;
    }

    public void addDDLProviders(DDLProvider ddlParticipant, DDLProvider ... ddlParticipants) {
        this.ddlProviders.add(ddlParticipant);
        this.ddlProviders.addAll(Arrays.asList(ddlParticipants));
    }

    public void addDDLProviders(Collection<? extends DDLProvider> ddlParticipants) {
        this.ddlProviders.addAll(ddlParticipants);
    }

    @Override
    public List<String> getCreationScripts() {
        return Collections.cat((Collection[])new Collection[]{this.generateTableCreationScripts(), this.generateSequencesCreationScripts(), this.generateDDLProvidersCreationScripts()});
    }

    protected List<String> generateDDLProvidersCreationScripts() {
        ArrayList<String> participantsScripts = new ArrayList<String>();
        for (DDLProvider ddlProvider : this.ddlProviders) {
            participantsScripts.addAll(ddlProvider.getCreationScripts());
        }
        return participantsScripts;
    }

    protected List<String> generateTableCreationScripts() {
        ArrayList<String> tableCreationScripts = new ArrayList<String>();
        ArrayList<String> foreignKeysCreationScripts = new ArrayList<String>();
        ArrayList<String> indexesCreationScripts = new ArrayList<String>();
        ArrayList<String> uniqueConstraintsCreationScripts = new ArrayList<String>();
        for (Table<?> table : this.tables) {
            tableCreationScripts.add(this.generateCreationScript(table));
            foreignKeysCreationScripts.addAll(this.getForeignKeyCreationScripts(table));
            indexesCreationScripts.addAll(this.generateIndexCreationScripts(table));
            uniqueConstraintsCreationScripts.addAll(this.generateUniqueConstraintCreationScripts(table));
        }
        return Collections.cat((Collection[])new Collection[]{tableCreationScripts, uniqueConstraintsCreationScripts, indexesCreationScripts, foreignKeysCreationScripts});
    }

    protected String generateCreationScript(Table<?> table) {
        return this.ddlTableGenerator.generateCreateTable(table);
    }

    protected List<String> generateUniqueConstraintCreationScripts(Table<?> table) {
        ArrayList<String> uniqueConstraintCreationScripts = new ArrayList<String>();
        for (UniqueConstraint<?> uniqueConstraint : table.getUniqueConstraints()) {
            uniqueConstraintCreationScripts.add(this.generateCreationScript(uniqueConstraint));
        }
        return uniqueConstraintCreationScripts;
    }

    protected List<String> generateIndexCreationScripts(Table<?> table) {
        ArrayList<String> indexesCreationScripts = new ArrayList<String>();
        for (Index<?> index : table.getIndexes()) {
            indexesCreationScripts.add(this.generateCreationScript(index));
        }
        return indexesCreationScripts;
    }

    protected String generateCreationScript(UniqueConstraint uniqueConstraint) {
        return this.ddlTableGenerator.generateCreateUniqueConstraint(uniqueConstraint);
    }

    protected String generateCreationScript(Index<?> index) {
        return this.ddlTableGenerator.generateCreateIndex(index);
    }

    protected List<String> getForeignKeyCreationScripts(Table<?> table) {
        ArrayList<String> foreignKeysCreationScripts = new ArrayList<String>();
        for (ForeignKey<?, ?, ?> foreignKey : table.getForeignKeys()) {
            foreignKeysCreationScripts.add(this.generateCreationScript(foreignKey));
        }
        return foreignKeysCreationScripts;
    }

    protected String generateCreationScript(ForeignKey<?, ?, ?> foreignKey) {
        return this.ddlTableGenerator.generateCreateForeignKey(foreignKey);
    }

    protected List<String> generateSequencesCreationScripts() {
        ArrayList<String> sequenceCreationScripts = new ArrayList<String>();
        for (Sequence sequence : this.sequences) {
            sequenceCreationScripts.add(this.ddlSequenceGenerator.generateCreateSequence(sequence));
        }
        return sequenceCreationScripts;
    }

    @Override
    public List<String> getDropScripts() {
        return Collections.cat((Collection[])new Collection[]{this.generateTableDropScripts(), this.generateSequencesDropScripts(), this.generateDDLParticipantsDropScripts()});
    }

    protected List<String> generateTableDropScripts() {
        ArrayList<String> tableCreationScripts = new ArrayList<String>();
        for (Table<?> table : this.tables) {
            tableCreationScripts.add(this.ddlTableGenerator.generateDropTable(table));
        }
        return tableCreationScripts;
    }

    protected List<String> generateDDLParticipantsDropScripts() {
        ArrayList<String> participantsScripts = new ArrayList<String>();
        for (DDLProvider ddlProvider : this.ddlProviders) {
            List<String> dropScripts = ddlProvider.getDropScripts();
            if (Collections.isEmpty(dropScripts)) continue;
            participantsScripts.addAll(dropScripts);
        }
        return participantsScripts;
    }

    protected List<String> generateSequencesDropScripts() {
        ArrayList<String> sequenceCreationScripts = new ArrayList<String>();
        for (Sequence sequence : this.sequences) {
            sequenceCreationScripts.add(this.ddlSequenceGenerator.generateDropSequence(sequence));
        }
        return sequenceCreationScripts;
    }
}

