/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.listener;

import java.util.ArrayList;
import java.util.List;
import org.codefilarete.stalactite.engine.listener.InsertListener;

public class InsertListenerCollection<C>
implements InsertListener<C> {
    private final List<InsertListener<C>> insertListeners = new ArrayList<InsertListener<C>>();

    @Override
    public void beforeInsert(Iterable<? extends C> entities) {
        this.insertListeners.forEach(listener -> listener.beforeInsert(entities));
    }

    @Override
    public void afterInsert(Iterable<? extends C> entities) {
        this.insertListeners.forEach(listener -> listener.afterInsert(entities));
    }

    @Override
    public void onInsertError(Iterable<? extends C> entities, RuntimeException runtimeException) {
        this.insertListeners.forEach(listener -> listener.onInsertError(entities, runtimeException));
    }

    public void add(InsertListener<? extends C> insertListener) {
        this.insertListeners.add(insertListener);
    }

    public void moveTo(InsertListenerCollection<C> insertListener) {
        insertListener.insertListeners.addAll(this.insertListeners);
        this.insertListeners.clear();
    }
}

