/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.codefilarete.tool.collection.Arrays;

public class InMemoryBlobSupport
implements Blob {
    private byte[] buffer;

    public InMemoryBlobSupport(int length) {
        this(new byte[length]);
    }

    public InMemoryBlobSupport(byte[] buffer) {
        this.buffer = buffer;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public long length() throws SQLException {
        this.assertNotFreed();
        return this.buffer.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.assertNotFreed();
        byte[] result = new byte[length];
        System.arraycopy(this.buffer, (int)pos - 1, result, 0, length);
        return result;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.assertNotFreed();
        return new ByteArrayInputStream(this.buffer);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (pos < 1L || pos > this.length() || pos + length > this.length()) {
            throw new SQLException("Incompatible position or length with actual byte count : " + this.length() + " vs " + pos + " + " + length);
        }
        return new ByteArrayInputStream(this.getBytes(pos, (int)length));
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        int offset;
        this.assertNotFreed();
        boolean found = true;
        int currIdx = (int)start - 1;
        for (offset = 0; found && currIdx < this.buffer.length && offset < pattern.length; ++offset, ++currIdx) {
            found = this.buffer[currIdx] == pattern[offset];
        }
        if (offset != pattern.length) {
            return this.position(pattern, start + 1L);
        }
        return (long)currIdx - (long)offset + 1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.assertNotFreed();
        if (pos + (long)len > (long)this.buffer.length) {
            this.resizeBuffer((int)(pos - 1L + (long)len));
        }
        for (int i = 0; i < len; ++i) {
            this.buffer[(int)(pos - 1L + (long)i)] = bytes[i + offset];
        }
        return len;
    }

    private void resizeBuffer(int newLength) {
        byte[] extendedBuffer = new byte[newLength];
        System.arraycopy(this.buffer, 0, extendedBuffer, 0, this.buffer.length);
        this.buffer = extendedBuffer;
    }

    private void extendBuffer(int chunckSize) {
        this.resizeBuffer(this.buffer.length + chunckSize);
    }

    @Override
    public OutputStream setBinaryStream(final long pos) throws SQLException {
        this.assertNotFreed();
        return new OutputStream(){
            private int offset;
            {
                this.offset = (int)pos - 1;
            }

            @Override
            public void write(int b) throws IOException {
                if (this.offset == InMemoryBlobSupport.this.buffer.length) {
                    InMemoryBlobSupport.this.extendBuffer(1);
                }
                ((InMemoryBlobSupport)InMemoryBlobSupport.this).buffer[this.offset++] = (byte)b;
            }
        };
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.assertNotFreed();
        if (len < (long)this.buffer.length) {
            this.buffer = Arrays.head((byte[])this.buffer, (int)((int)len));
        }
    }

    @Override
    public void free() throws SQLException {
        this.buffer = null;
    }

    private void assertNotFreed() throws SQLException {
        if (this.buffer == null) {
            throw new SQLException("Blob data is no more available because it was freed");
        }
    }
}

