/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;
import org.codefilarete.stalactite.sql.statement.binder.DateBinder;
import org.codefilarete.stalactite.sql.statement.binder.LocalDateBinder;
import org.codefilarete.stalactite.sql.statement.binder.LocalDateTimeBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwarePreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.NullSafeguardPreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.PathBinder;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.UUIDParameterBinder;

public final class DefaultPreparedStatementWriters {
    public static final PreparedStatementWriter<Long> SET_LONG_WRITER = PreparedStatementWriter.ofMethodReference(PreparedStatement::setLong);
    public static final PreparedStatementWriter<Long> LONG_PRIMITIVE_WRITER = new NullSafeguardPreparedStatementWriter<Long>(SET_LONG_WRITER);
    public static final PreparedStatementWriter<Long> LONG_WRITER = new NullAwarePreparedStatementWriter<Long>(SET_LONG_WRITER);
    private static final PreparedStatementWriter<Integer> SET_INT_WRITER = PreparedStatementWriter.ofMethodReference(PreparedStatement::setInt);
    public static final PreparedStatementWriter<Integer> INTEGER_PRIMITIVE_WRITER = new NullSafeguardPreparedStatementWriter<Integer>(SET_INT_WRITER);
    public static final PreparedStatementWriter<Integer> INTEGER_WRITER = new NullAwarePreparedStatementWriter<Integer>(SET_INT_WRITER);
    private static final PreparedStatementWriter<Byte> SET_BYTE_WRITER = PreparedStatementWriter.ofMethodReference(PreparedStatement::setByte);
    public static final PreparedStatementWriter<Byte> BYTE_PRIMITIVE_WRITER = new NullSafeguardPreparedStatementWriter<Byte>(SET_BYTE_WRITER);
    public static final PreparedStatementWriter<Byte> BYTE_WRITER = new NullAwarePreparedStatementWriter<Byte>(SET_BYTE_WRITER);
    public static final PreparedStatementWriter<byte[]> BYTES_WRITER = new NullAwarePreparedStatementWriter<byte[]>(PreparedStatement::setBytes);
    private static final PreparedStatementWriter<Double> SET_DOUBLE_WRITER = PreparedStatementWriter.ofMethodReference(PreparedStatement::setDouble);
    public static final PreparedStatementWriter<Double> DOUBLE_PRIMITIVE_WRITER = new NullSafeguardPreparedStatementWriter<Double>(SET_DOUBLE_WRITER);
    public static final PreparedStatementWriter<Double> DOUBLE_WRITER = new NullAwarePreparedStatementWriter<Double>(SET_DOUBLE_WRITER);
    private static final PreparedStatementWriter<Float> SET_FLOAT_WRITER = PreparedStatementWriter.ofMethodReference(PreparedStatement::setFloat);
    public static final PreparedStatementWriter<Float> FLOAT_PRIMITIVE_WRITER = new NullSafeguardPreparedStatementWriter<Float>(SET_FLOAT_WRITER);
    public static final PreparedStatementWriter<Float> FLOAT_WRITER = new NullAwarePreparedStatementWriter<Float>(SET_FLOAT_WRITER);
    public static final PreparedStatementWriter<BigDecimal> BIGDECIMAL_WRITER = new NullAwarePreparedStatementWriter<BigDecimal>(PreparedStatement::setBigDecimal);
    private static final PreparedStatementWriter<Boolean> SET_BOOLEAN_WRITER = PreparedStatementWriter.ofMethodReference(PreparedStatement::setBoolean);
    public static final PreparedStatementWriter<Boolean> BOOLEAN_PRIMITIVE_WRITER = new NullSafeguardPreparedStatementWriter<Boolean>(SET_BOOLEAN_WRITER);
    public static final PreparedStatementWriter<Boolean> BOOLEAN_WRITER = new NullAwarePreparedStatementWriter<Boolean>(SET_BOOLEAN_WRITER);
    public static final PreparedStatementWriter<Date> DATE_SQL_WRITER = new NullAwarePreparedStatementWriter<Date>(PreparedStatement::setDate);
    public static final PreparedStatementWriter<Timestamp> TIMESTAMP_WRITER = new NullAwarePreparedStatementWriter<Timestamp>(PreparedStatement::setTimestamp);
    public static final PreparedStatementWriter<String> STRING_WRITER = new NullAwarePreparedStatementWriter<String>(PreparedStatement::setString);
    public static final PreparedStatementWriter<InputStream> BINARYSTREAM_WRITER = new NullAwarePreparedStatementWriter<InputStream>(PreparedStatement::setBinaryStream);
    public static final PreparedStatementWriter<Blob> BLOB_WRITER = new NullAwarePreparedStatementWriter<Blob>(PreparedStatement::setBlob);
    public static final PreparedStatementWriter<InputStream> BLOB_INPUTSTREAM_WRITER = new NullAwarePreparedStatementWriter<InputStream>(PreparedStatement::setBinaryStream);
    public static final PreparedStatementWriter<java.util.Date> DATE_WRITER = new NullAwarePreparedStatementWriter<java.util.Date>(new DateBinder());
    public static final PreparedStatementWriter<LocalDate> LOCALDATE_WRITER = new NullAwarePreparedStatementWriter<LocalDate>(new LocalDateBinder());
    public static final PreparedStatementWriter<LocalDateTime> LOCALDATETIME_WRITER = new NullAwarePreparedStatementWriter<LocalDateTime>(new LocalDateTimeBinder());
    public static final PreparedStatementWriter<UUID> UUID_WRITER = new NullAwarePreparedStatementWriter<UUID>(new UUIDParameterBinder());
    public static final PreparedStatementWriter<Path> PATH_WRITER = new NullAwarePreparedStatementWriter<Path>(new PathBinder());
    public static final PreparedStatementWriter<Number> NUMBER_WRITER = new PreparedStatementWriter<Number>(){

        @Override
        public void set(PreparedStatement preparedStatement, int valueIndex, Number value) throws SQLException {
            preparedStatement.setDouble(valueIndex, value.doubleValue());
        }

        @Override
        public Class<Number> getType() {
            return Number.class;
        }
    };

    private DefaultPreparedStatementWriters() {
    }
}

