/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;

public class ReadOperation<ParamType>
extends SQLOperation<ParamType> {
    private final Integer fetchSize;

    public ReadOperation(SQLStatement<ParamType> sqlStatement, ConnectionProvider connectionProvider) {
        this(sqlStatement, connectionProvider, null);
    }

    public ReadOperation(SQLStatement<ParamType> sqlStatement, ConnectionProvider connectionProvider, Integer fetchSize) {
        super(sqlStatement, connectionProvider);
        this.fetchSize = fetchSize;
    }

    @Override
    protected void prepareStatement(Connection connection) throws SQLException {
        super.prepareStatement(connection);
        if (this.fetchSize != null) {
            this.preparedStatement.setFetchSize(this.fetchSize);
        }
    }

    public ResultSet execute() {
        this.prepareExecute();
        try {
            return this.preparedStatement.executeQuery();
        }
        catch (SQLException e) {
            throw new SQLExecutionException(this.getSQL(), e);
        }
    }
}

