/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.sql.result.ColumnReader;
import org.codefilarete.stalactite.sql.result.SingleColumnReader;
import org.codefilarete.tool.collection.Iterables;

public class MultipleColumnsReader<C>
implements ColumnReader<C> {
    private final Set<SingleColumnReader> columnReaders;
    private final Function<Map<String, Object>, C> assembler;

    public MultipleColumnsReader(Set<SingleColumnReader> columnReaders, Function<Map<String, Object>, C> assembler) {
        this.columnReaders = columnReaders;
        this.assembler = assembler;
    }

    @Override
    public C read(ResultSet resultSet) {
        Map rowValues = Iterables.map(this.columnReaders, SingleColumnReader::getColumnName, reader -> reader.read(resultSet));
        return this.assembler.apply(rowValues);
    }

    @Override
    public MultipleColumnsReader<C> copyWithAliases(Function<String, String> columnMapping) {
        Set resultColumnReaders = (Set)Iterables.collect(this.columnReaders, r -> r.copyWithAliases((Function)columnMapping), HashSet::new);
        return new MultipleColumnsReader<C>(resultColumnReaders, this.assembler);
    }
}

