/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.function.Hanger;

public final class Accumulators {
    public static <T, C extends Collection<T>> Accumulator<T, C, C> toCollection(Supplier<C> collectionFactory) {
        return new CollectionSupport(collectionFactory);
    }

    public static <T> Accumulator<T, ? extends List<T>, List<T>> toList() {
        return new CollectionSupport(ArrayList::new);
    }

    public static <T> Accumulator<T, ? extends List<T>, List<T>> toUnmodifiableList() {
        return Accumulators.toList().andThen(Collections::unmodifiableList);
    }

    public static <T> Accumulator<T, ? extends Set<T>, Set<T>> toSet() {
        return new CollectionSupport(HashSet::new);
    }

    public static <T> Accumulator<T, ? extends Set<T>, Set<T>> toUnmodifiableSet() {
        return Accumulators.toSet().andThen(Collections::unmodifiableSet);
    }

    public static <T> Accumulator<T, Set<T>, Set<T>> toKeepingOrderSet() {
        return new CollectionSupport(LinkedHashSet::new);
    }

    public static <T> Accumulator<T, NavigableSet<T>, NavigableSet<T>> toSortedSet(Comparator<T> comparator) {
        return new CollectionSupport(() -> new TreeSet(comparator));
    }

    public static <T, K> Accumulator<T, ?, Map<K, T>> groupingBy(Function<? super T, ? extends K> keyMapper) {
        return Accumulators.groupingBy(keyMapper, HashMap::new, Accumulators.getFirst());
    }

    public static <T, K, V> Accumulator<T, ?, Map<K, V>> groupingBy(Function<? super T, ? extends K> keyMapper, Accumulator<? super T, ?, V> downstream) {
        return Accumulators.groupingBy(keyMapper, HashMap::new, downstream);
    }

    public static <T, K, V, S, M extends Map<K, V>> Accumulator<T, ?, M> groupingBy(Function<? super T, ? extends K> keyMapper, Supplier<M> mapFactory, Accumulator<? super T, S, V> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAggregator = downstream.aggregator();
        BiConsumer<Map, Object> accumulator = (m, t) -> {
            Object key = keyMapper.apply(t);
            Object container = m.computeIfAbsent(key, arg_0 -> Accumulators.lambda$null$1((Supplier)downstreamSupplier, arg_0));
            downstreamAggregator.accept(container, t);
        };
        Function downstreamFinisher = downstream.finisher();
        Function<Map, Map> finisher = resultingMap -> {
            resultingMap.replaceAll((k, v) -> downstreamFinisher.apply(v));
            return resultingMap;
        };
        return new AccumulatorSupport<Object, Map, Map>(mapFactory, accumulator, finisher);
    }

    public static <T, K, S, R> Accumulator<T, ?, R> mapping(Function<? super T, ? extends K> mapper, Accumulator<? super K, S, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.aggregator();
        return new AccumulatorSupport<Object, Object, R>(downstream.supplier(), (r, t) -> downstreamAccumulator.accept((Object)r, (Object)mapper.apply(t)), downstream.finisher());
    }

    public static <T> Accumulator<T, ?, T> getFirst() {
        return new AccumulatorSupport<Object, Hanger.Holder, Object>(Hanger.Holder::new, (holder, t) -> {
            if (holder.get() == null) {
                holder.set(t);
            }
        }, Hanger.Holder::get);
    }

    public static <T> Accumulator<T, ?, T> getFirstUnique() {
        return new AccumulatorSupport<Object, Hanger.Holder, Object>(Hanger.Holder::new, (holder, t) -> {
            if (holder.get() != null) {
                throw new NonUniqueObjectException("Object was expected to be a lonely one but another object is present");
            }
            holder.set(t);
        }, Hanger.Holder::get);
    }

    private Accumulators() {
    }

    private static /* synthetic */ Object lambda$null$1(Supplier downstreamSupplier, Object k) {
        return downstreamSupplier.get();
    }

    public static class NonUniqueObjectException
    extends RuntimeException {
        public NonUniqueObjectException(String message) {
            super(message);
        }
    }

    static class AccumulatorSupport<T, S, R>
    implements Accumulator<T, S, R> {
        private final Supplier<S> supplier;
        private final BiConsumer<S, T> accumulator;
        private final Function<S, R> finisher;

        AccumulatorSupport(Supplier<S> supplier, BiConsumer<S, T> accumulator, Function<S, R> finisher) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        AccumulatorSupport(Supplier<S> supplier, BiConsumer<S, T> accumulator) {
            this(supplier, accumulator, s -> s);
        }

        @Override
        public Supplier<S> supplier() {
            return this.supplier;
        }

        @Override
        public BiConsumer<S, T> aggregator() {
            return this.accumulator;
        }

        @Override
        public Function<S, R> finisher() {
            return this.finisher;
        }
    }

    static class CollectionSupport<T, C extends Collection<T>>
    extends AccumulatorSupport<T, C, C> {
        CollectionSupport(Supplier<C> supplier) {
            super(supplier, Collection::add);
        }
    }
}

