/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.tool.sql.ConnectionWrapper;

public class CurrentThreadConnectionProvider
implements ConnectionProvider {
    private final ConnectionProvider dataSource;
    private final ThreadLocal<Connection> currentConnection = new ThreadLocal();

    public CurrentThreadConnectionProvider(DataSource dataSource) {
        this(new ConnectionProvider.DataSourceConnectionProvider(dataSource));
    }

    public CurrentThreadConnectionProvider(ConnectionProvider dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Connection giveConnection() {
        Connection connection = this.currentConnection.get();
        try {
            if (connection == null) {
                return this.fillCurrentConnection();
            }
            if (connection.isClosed()) {
                this.currentConnection.remove();
                return this.fillCurrentConnection();
            }
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Connection fillCurrentConnection() {
        try {
            CurrentThreadDetacherConnection connection = new CurrentThreadDetacherConnection(this.dataSource.giveConnection());
            connection.setAutoCommit(false);
            this.currentConnection.set((Connection)((Object)connection));
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void releaseConnection() {
        this.currentConnection.remove();
    }

    private class CurrentThreadDetacherConnection
    extends ConnectionWrapper {
        private CurrentThreadDetacherConnection(Connection connection) {
            super(connection);
        }

        public void close() throws SQLException {
            CurrentThreadConnectionProvider.this.releaseConnection();
            super.close();
        }
    }
}

