/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.execution.reduce;

import java.util.List;
import java.util.function.Supplier;
import org.codefilarete.stalactite.spring.repository.query.StalactiteRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.execution.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.LimitHandler;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.QueryResultWindower;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;

public class SliceResultWindower<C, R, P>
extends QueryResultWindower<C, R, P> {
    public SliceResultWindower(StalactiteRepositoryQuery<C, ?> delegate, LimitHandler limitHandler, Supplier<List<P>> resultSupplier) {
        super(delegate, limitHandler, (accessor, result) -> {
            int pageSize = 0;
            Pageable pageable = accessor.getPageable();
            if (pageable.isPaged()) {
                pageSize = pageable.getPageSize();
            }
            boolean hasNext = pageable.isPaged() && result.size() > pageSize;
            return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, pageable, hasNext);
        }, resultSupplier);
    }

    @Override
    protected void adaptLimit(StalactiteQueryMethodInvocationParameters invocationParameters) {
        Pageable pageable = invocationParameters.getPageable();
        if (!pageable.isUnpaged()) {
            if (pageable.getPageNumber() == 0) {
                this.limitHandler.limit(pageable.getPageSize() + 1);
            } else {
                this.limitHandler.limit(pageable.getPageSize(), (int)pageable.getOffset());
            }
        }
    }
}

