/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.Map;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.idpolicy.GeneratedKeysPolicy;
import org.codefilarete.stalactite.dsl.key.CompositeKeyMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.UniqueConstraintNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.EmbeddableMapping;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.EmbeddableMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.entity.CompositeKeyLinkageSupport;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.VisibleForTesting;

public class PrimaryKeyStep<C, I> {
    @VisibleForTesting
    <T extends Table<T>> PrimaryKey<T, I> addIdentifyingPrimarykey(AbstractIdentification<C, I> identification, Map<EntityMappingConfiguration, Table> tableMap, ColumnBinderRegistry columnBinderRegistry, ColumnNamingStrategy columnNamingStrategy, UniqueConstraintNamingStrategy uniqueConstraintNamingStrategy) {
        Table pkTable = tableMap.get(identification.getIdentificationDefiner());
        EntityMappingConfiguration.KeyMapping<C, I> keyLinkage = identification.getKeyLinkage();
        AccessorDefinition identifierDefinition = AccessorDefinition.giveDefinition(identification.getIdAccessor());
        if (identification instanceof AbstractIdentification.CompositeKeyIdentification) {
            CompositeKeyMappingConfiguration configuration = ((CompositeKeyLinkageSupport)keyLinkage).getCompositeKeyMappingBuilder().getConfiguration();
            EmbeddableMappingBuilder compositeKeyBuilder = new EmbeddableMappingBuilder(configuration, pkTable, columnBinderRegistry, columnNamingStrategy, uniqueConstraintNamingStrategy);
            EmbeddableMapping build = compositeKeyBuilder.build();
            Map compositeKeyMapping = build.getMapping();
            compositeKeyMapping.values().forEach(Column::primaryKey);
            ((AbstractIdentification.CompositeKeyIdentification)identification).setCompositeKeyMapping(compositeKeyMapping);
        } else {
            String columnName = this.determineColumnName((EntityMappingConfiguration.SingleKeyMapping)keyLinkage, columnNamingStrategy);
            Column primaryKey = pkTable.addColumn(columnName, identifierDefinition.getMemberType(), ((EntityMappingConfiguration.SingleKeyMapping)keyLinkage).getColumnOptions().getColumnSize(), Boolean.valueOf(false));
            primaryKey.primaryKey();
            if (((AbstractIdentification.SingleColumnIdentification)identification).getIdentifierPolicy() instanceof GeneratedKeysPolicy) {
                primaryKey.autoGenerated();
            }
        }
        return pkTable.getPrimaryKey();
    }

    private <O> String determineColumnName(EntityMappingConfiguration.SingleKeyMapping<C, O> keyLinkage, ColumnNamingStrategy columnNamingStrategy) {
        return (String)Nullable.nullable((Object)keyLinkage.getColumnOptions().getColumnName()).elseSet(keyLinkage::getFieldName).elseSet(() -> columnNamingStrategy.giveName(AccessorDefinition.giveDefinition(keyLinkage.getAccessor()))).get();
    }
}

