/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.function.Function;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderPipeline;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EntityIsManagedByPersisterAsserter;
import org.codefilarete.stalactite.engine.runtime.OptimizedUpdatePersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.tool.Reflections;

public class DefaultPersisterBuilder {
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private final PersisterRegistry persisterRegistry;

    public DefaultPersisterBuilder(PersistenceContext persistenceContext) {
        this(persistenceContext.getDialect(), persistenceContext.getConnectionConfiguration(), (PersisterRegistry)new PersisterRegistry.DefaultPersisterRegistry(persistenceContext.getPersisters()));
    }

    public DefaultPersisterBuilder(Dialect dialect, ConnectionConfiguration connectionConfiguration, PersisterRegistry persisterRegistry) {
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.persisterRegistry = persisterRegistry;
    }

    public <C, I> ConfiguredRelationalPersister<C, I> build(EntityMappingConfigurationProvider<C, I> entityMappingConfiguration) {
        return this.build(entityMappingConfiguration.getConfiguration());
    }

    public <C, I> ConfiguredRelationalPersister<C, I> build(EntityMappingConfiguration<C, I> entityMappingConfiguration) {
        EntityPersister existingPersister = this.persisterRegistry.getPersister(entityMappingConfiguration.getEntityType());
        if (existingPersister != null) {
            throw new IllegalStateException("Persister already exists for " + Reflections.toString(entityMappingConfiguration.getEntityType()));
        }
        return this.doBuild(entityMappingConfiguration);
    }

    public <C, I> ConfiguredRelationalPersister<C, I> buildOrGiveExisting(EntityMappingConfiguration<C, I> entityMappingConfiguration) {
        EntityPersister existingPersister = this.persisterRegistry.getPersister(entityMappingConfiguration.getEntityType());
        if (existingPersister != null) {
            return (ConfiguredRelationalPersister)existingPersister;
        }
        return this.doBuild(entityMappingConfiguration);
    }

    private <C, I> ConfiguredRelationalPersister<C, I> doBuild(EntityMappingConfiguration<C, I> entityMappingConfiguration) {
        ConfiguredRelationalPersister<C, I> result = this.decorateWithUpdateOptimization(adaptedConnectionConfiguration -> {
            PersisterBuilderPipeline persisterBuilderPipeline = new PersisterBuilderPipeline(this.dialect, (ConnectionConfiguration)adaptedConnectionConfiguration, this.persisterRegistry);
            return persisterBuilderPipeline.build(entityMappingConfiguration);
        });
        result = this.decorateWithEntityManagementAsserter(result);
        return result;
    }

    private <C, I> OptimizedUpdatePersister<C, I> decorateWithUpdateOptimization(Function<ConnectionConfiguration, ConfiguredRelationalPersister<C, I>> builderDelegate) {
        ConfiguredRelationalPersister<C, I> concretePersister = builderDelegate.apply(OptimizedUpdatePersister.wrapWithQueryCache(this.connectionConfiguration));
        return new OptimizedUpdatePersister<C, I>(concretePersister);
    }

    private <C, I> ConfiguredRelationalPersister<C, I> decorateWithEntityManagementAsserter(ConfiguredRelationalPersister<C, I> concretePersister) {
        return new EntityIsManagedByPersisterAsserter<C, I>(concretePersister);
    }
}

