/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.configurer.DefaultComposedIdentifierAssembler;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementRecordMapping;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecord;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMapping;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.model.compositekey.House;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.TablePerClassRootJoinNode;
import org.codefilarete.stalactite.engine.runtime.query.AggregateAccessPointToColumnMapping;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.EmbeddedBeanMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.SingleIdentifierAssembler;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AggregateAccessPointToColumnMappingTest {
    AggregateAccessPointToColumnMappingTest() {
    }

    @Test
    <T extends Table<T>> void rootNode_withSimpleIdentifierMapping() {
        EntityMapping entityMappingMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Table personTable = new Table("Person");
        Column idColumn = personTable.addColumn("id", Identifier.LONG_TYPE);
        Column nameColumn = personTable.addColumn("name", String.class);
        Column versionColumn = personTable.addColumn("version", Long.TYPE);
        Mockito.when((Object)entityMappingMock.getTargetTable()).thenReturn((Object)personTable);
        Mockito.when((Object)entityMappingMock.getPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(Person::getName), (Object)nameColumn));
        Mockito.when((Object)entityMappingMock.getReadonlyPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(Person::getVersion), (Object)versionColumn));
        IdMapping idMapping = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)entityMappingMock.getIdMapping()).thenReturn((Object)idMapping);
        Mockito.when((Object)idMapping.getIdentifierAssembler()).thenReturn((Object)new SingleIdentifierAssembler(idColumn));
        Mockito.when((Object)idMapping.getIdAccessor()).thenReturn((Object)new AccessorWrapperIdAccessor((ReversibleAccessor)Accessors.accessor(Person::getId)));
        EntityJoinTree personTree = new EntityJoinTree(entityMappingMock);
        AggregateAccessPointToColumnMapping testInstance = new AggregateAccessPointToColumnMapping(personTree, true);
        Map result = testInstance.getPropertyToColumn();
        EntityCriteriaSupport.AccessorToColumnMap accessorToColumnMap = new EntityCriteriaSupport.AccessorToColumnMap();
        accessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorChain[]{AccessorChain.fromMethodReference(Person::getId)}), (Object)idColumn);
        accessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorChain[]{AccessorChain.fromMethodReference(Person::getName)}), (Object)nameColumn);
        accessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorChain[]{AccessorChain.fromMethodReference(Person::getVersion)}), (Object)versionColumn);
        Assertions.assertThat((Map)result).isEqualTo((Object)accessorToColumnMap);
    }

    @Test
    <T extends Table<T>> void rootNode_withComplexIdentifierMapping() {
        EntityMapping entityMappingMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Table personTable = new Table("House");
        Column nameColumn = personTable.addColumn("name", String.class);
        Column versionColumn = personTable.addColumn("version", Long.TYPE);
        Column numberColumn = personTable.addColumn("number", Integer.TYPE);
        Column streetColumn = personTable.addColumn("street", String.class);
        Mockito.when((Object)entityMappingMock.getTargetTable()).thenReturn((Object)personTable);
        Mockito.when((Object)entityMappingMock.getPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(House::getSurname), (Object)nameColumn));
        Mockito.when((Object)entityMappingMock.getReadonlyPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(House::getVersion), (Object)versionColumn));
        IdMapping idMapping = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)entityMappingMock.getIdMapping()).thenReturn((Object)idMapping);
        Mockito.when((Object)idMapping.getIdAccessor()).thenReturn((Object)new AccessorWrapperIdAccessor((ReversibleAccessor)Accessors.accessor(House::getHouseId)));
        Mockito.when((Object)idMapping.getIdentifierAssembler()).thenReturn((Object)new DefaultComposedIdentifierAssembler(personTable, House.HouseId.class, (Map)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(House.HouseId::getNumber), (Object)numberColumn).add((Object)Accessors.accessor(House.HouseId::getStreet), (Object)streetColumn)));
        EntityJoinTree personTree = new EntityJoinTree(entityMappingMock);
        AggregateAccessPointToColumnMapping testInstance = new AggregateAccessPointToColumnMapping(personTree, true);
        Map result = testInstance.getPropertyToColumn();
        EntityCriteriaSupport.AccessorToColumnMap accessorToColumnMap = new EntityCriteriaSupport.AccessorToColumnMap();
        accessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorChain[]{AccessorChain.fromMethodReference(House::getHouseId), AccessorChain.fromMethodReference(House.HouseId::getNumber)}), (Object)numberColumn);
        accessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorChain[]{AccessorChain.fromMethodReference(House::getHouseId), AccessorChain.fromMethodReference(House.HouseId::getStreet)}), (Object)streetColumn);
        accessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorChain[]{AccessorChain.fromMethodReference(House::getSurname)}), (Object)nameColumn);
        accessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorChain[]{AccessorChain.fromMethodReference(House::getVersion)}), (Object)versionColumn);
        Assertions.assertThat((Map)result).isEqualTo((Object)accessorToColumnMap);
    }

    @Test
    <T extends Table<T>> void tablePerClassRootJoinNode_withSimpleIdentifierMapping() {
        EntityMapping entityMappingMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Table personTable = new Table("Person");
        Column idColumn = personTable.addColumn("id", Identifier.LONG_TYPE);
        Column nameColumn = personTable.addColumn("name", String.class);
        Column versionColumn = personTable.addColumn("version", Long.TYPE);
        Column discriminatorColumn = personTable.addColumn("DTYPE", Long.TYPE);
        Mockito.when((Object)entityMappingMock.getTargetTable()).thenReturn((Object)personTable);
        Mockito.when((Object)entityMappingMock.getPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(Person::getName), (Object)nameColumn));
        Mockito.when((Object)entityMappingMock.getReadonlyPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(Person::getVersion), (Object)versionColumn));
        IdMapping idMapping = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)entityMappingMock.getIdMapping()).thenReturn((Object)idMapping);
        Mockito.when((Object)idMapping.getIdentifierAssembler()).thenReturn((Object)new SingleIdentifierAssembler(idColumn));
        Mockito.when((Object)idMapping.getIdAccessor()).thenReturn((Object)new AccessorWrapperIdAccessor((ReversibleAccessor)Accessors.accessor(Person::getId)));
        QueryStatement.PseudoTable pseudoTable = new QueryStatement.PseudoTable(QueryEase.select((Selectable)idColumn, (Selectable[])new Selectable[]{nameColumn, versionColumn}).from((Fromable)personTable).getQuery(), "dummyUnion");
        ConfiguredRelationalPersister rootPersisterMock = (ConfiguredRelationalPersister)Mockito.mock(ConfiguredRelationalPersister.class);
        Mockito.when((Object)rootPersisterMock.getMapping()).thenReturn((Object)entityMappingMock);
        EntityJoinTree personTree = new EntityJoinTree(tree -> new TablePerClassRootJoinNode(tree, rootPersisterMock, Collections.emptyMap(), pseudoTable, new Selectable.SimpleSelectable("discriminatorColumn", String.class)));
        AggregateAccessPointToColumnMapping testInstance = new AggregateAccessPointToColumnMapping(personTree, true);
        Map result = testInstance.getPropertyToColumn();
        EntityCriteriaSupport.AccessorToColumnMap accessorToColumnMap = new EntityCriteriaSupport.AccessorToColumnMap();
        accessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorChain[]{AccessorChain.fromMethodReference(Person::getId)}), (Object)pseudoTable.findColumn(idColumn.getName()));
        accessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorChain[]{AccessorChain.fromMethodReference(Person::getName)}), (Object)pseudoTable.findColumn(nameColumn.getName()));
        accessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorChain[]{AccessorChain.fromMethodReference(Person::getVersion)}), (Object)pseudoTable.findColumn(versionColumn.getName()));
        Assertions.assertThat((Map)result).isEqualTo((Object)accessorToColumnMap);
    }

    @Test
    <T1 extends Table<T1>, T2 extends Table<T2>> void relationJoinNode_collectionProperty() {
        EntityMapping entityMappingMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Table personTable = new Table("Person");
        Column idColumn = personTable.addColumn("id", Identifier.LONG_TYPE);
        Column nameColumn = personTable.addColumn("name", String.class);
        Column versionColumn = personTable.addColumn("version", Long.TYPE);
        Mockito.when((Object)entityMappingMock.getTargetTable()).thenReturn((Object)personTable);
        Mockito.when((Object)entityMappingMock.getPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(Person::getName), (Object)nameColumn));
        Mockito.when((Object)entityMappingMock.getReadonlyPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(Person::getVersion), (Object)versionColumn));
        IdMapping idMapping = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)entityMappingMock.getIdMapping()).thenReturn((Object)idMapping);
        Mockito.when((Object)idMapping.getIdentifierAssembler()).thenReturn((Object)new SingleIdentifierAssembler(idColumn));
        Mockito.when((Object)idMapping.getIdAccessor()).thenReturn((Object)new AccessorWrapperIdAccessor((ReversibleAccessor)Accessors.accessor(Person::getId)));
        EntityJoinTree personTree = new EntityJoinTree(entityMappingMock);
        Key leftJoinKey = Key.ofSingleColumn((JoinLink)idColumn);
        Set selectables = Collections.emptySet();
        Table collectionTable = new Table("collectionTable");
        Column collectionIdColumn = collectionTable.addColumn("id", Identifier.LONG_TYPE).primaryKey();
        Column nicknameColumn = collectionTable.addColumn("nickname", String.class);
        Key rightJoinKey = Key.ofSingleColumn((JoinLink)collectionIdColumn);
        ElementRecordMapping collectionMapping = new ElementRecordMapping(collectionTable, nicknameColumn, (IdentifierAssembler)Mockito.mock(IdentifierAssembler.class), Collections.emptyMap());
        EntityInflater entityInflater = (EntityInflater)Mockito.mock(EntityInflater.class);
        Mockito.when((Object)entityInflater.getEntityMapping()).thenReturn((Object)collectionMapping);
        AccessorByMethodReference nicknamesAccessor = Accessors.accessorByMethodReference(Person::getNicknames);
        BeanRelationFixer relationFixer = BeanRelationFixer.ofAdapter((arg_0, arg_1) -> ((MutatorByMethodReference)Accessors.mutatorByMethodReference(Person::setNicknames)).set(arg_0, arg_1), arg_0 -> ((AccessorByMethodReference)Accessors.accessorByMethodReference(Person::getNicknames)).get(arg_0), HashSet::new, (bean, input, collection) -> collection.add(input.getElement()));
        new RelationJoinNode((JoinNode)personTree.getRoot(), (Accessor)nicknamesAccessor, leftJoinKey, rightJoinKey, EntityJoinTree.JoinType.OUTER, selectables, "tableAlias", entityInflater, relationFixer, null);
        AggregateAccessPointToColumnMapping testInstance = new AggregateAccessPointToColumnMapping(personTree, true);
        EntityCriteriaSupport.AccessorToColumnMap expectedAccessorToColumnMap = new EntityCriteriaSupport.AccessorToColumnMap();
        expectedAccessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{Accessors.accessorByMethodReference(Person::getId)}), (Object)idColumn);
        expectedAccessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{Accessors.accessorByMethodReference(Person::getName)}), (Object)nameColumn);
        expectedAccessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{Accessors.accessorByMethodReference(Person::getVersion)}), (Object)versionColumn);
        expectedAccessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{Accessors.accessorByMethodReference(Person::getNicknames)}), (Object)nicknameColumn);
        Assertions.assertThat((Map)testInstance.getPropertyToColumn()).isEqualTo((Object)expectedAccessorToColumnMap);
    }

    @Test
    <T1 extends Table<T1>, T2 extends Table<T2>> void relationJoinNode_mapProperty_simpleKey_simpleValue() {
        EntityMapping entityMappingMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Table personTable = new Table("Person");
        Column idColumn = personTable.addColumn("id", Identifier.LONG_TYPE);
        Column nameColumn = personTable.addColumn("name", String.class);
        Column versionColumn = personTable.addColumn("version", Long.TYPE);
        Mockito.when((Object)entityMappingMock.getTargetTable()).thenReturn((Object)personTable);
        Mockito.when((Object)entityMappingMock.getPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(Person::getName), (Object)nameColumn));
        Mockito.when((Object)entityMappingMock.getReadonlyPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(Person::getVersion), (Object)versionColumn));
        IdMapping idMapping = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)entityMappingMock.getIdMapping()).thenReturn((Object)idMapping);
        Mockito.when((Object)idMapping.getIdentifierAssembler()).thenReturn((Object)new SingleIdentifierAssembler(idColumn));
        Mockito.when((Object)idMapping.getIdAccessor()).thenReturn((Object)new AccessorWrapperIdAccessor((ReversibleAccessor)Accessors.accessor(Person::getId)));
        EntityJoinTree personTree = new EntityJoinTree(entityMappingMock);
        Key leftJoinKey = Key.ofSingleColumn((JoinLink)idColumn);
        Set selectables = Collections.emptySet();
        Table mapTable = new Table("mapTable");
        Column mapIdColumn = mapTable.addColumn("id", Identifier.LONG_TYPE).primaryKey();
        Column keyColumn = mapTable.addColumn("key", String.class);
        Column valueColumn = mapTable.addColumn("value", String.class);
        Key rightJoinKey = Key.ofSingleColumn((JoinLink)mapIdColumn);
        PropertyAccessor phoneNumbersAccessor = KeyValueRecord.VALUE_ACCESSOR;
        HashMap<PropertyAccessor, Column> propertiesMapping = new HashMap<PropertyAccessor, Column>();
        propertiesMapping.put(phoneNumbersAccessor, valueColumn);
        KeyValueRecordMapping mapMapping = new KeyValueRecordMapping(mapTable, propertiesMapping, new KeyValueRecordMapping.KeyValueRecordIdMapping(mapTable, (EmbeddedBeanMapping)Mockito.mock(EmbeddedBeanMapping.class), (IdentifierAssembler)Mockito.mock(IdentifierAssembler.class), null));
        EntityInflater entityInflater = (EntityInflater)Mockito.mock(EntityInflater.class);
        Mockito.when((Object)entityInflater.getEntityMapping()).thenReturn((Object)mapMapping);
        BeanRelationFixer relationFixer = BeanRelationFixer.ofMapAdapter((arg_0, arg_1) -> ((MutatorByMethodReference)Accessors.mutatorByMethodReference(Person::setPhoneNumbers)).set(arg_0, arg_1), arg_0 -> ((AccessorByMethodReference)Accessors.accessorByMethodReference(Person::getPhoneNumbers)).get(arg_0), HashMap::new, (bean, input, collection) -> {
            String cfr_ignored_0 = (String)collection.put(input.getKey(), input.getValue());
        });
        new RelationJoinNode((JoinNode)personTree.getRoot(), (Accessor)Accessors.accessorByMethodReference(Person::getPhoneNumbers), leftJoinKey, rightJoinKey, EntityJoinTree.JoinType.OUTER, selectables, "tableAlias", entityInflater, relationFixer, null);
        AggregateAccessPointToColumnMapping testInstance = new AggregateAccessPointToColumnMapping(personTree, true);
        EntityCriteriaSupport.AccessorToColumnMap expectedAccessorToColumnMap = new EntityCriteriaSupport.AccessorToColumnMap();
        expectedAccessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{Accessors.accessorByMethodReference(Person::getId)}), (Object)idColumn);
        expectedAccessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{Accessors.accessorByMethodReference(Person::getName)}), (Object)nameColumn);
        expectedAccessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{Accessors.accessorByMethodReference(Person::getVersion)}), (Object)versionColumn);
        expectedAccessorToColumnMap.put((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{Accessors.accessorByMethodReference(Person::getPhoneNumbers)}), (Object)valueColumn);
        Assertions.assertThat((Map)testInstance.getPropertyToColumn()).isEqualTo((Object)expectedAccessorToColumnMap);
    }
}

