/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityFinder;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class RelationalEntityFinderTest {
    RelationalEntityFinderTest() {
    }

    @Test
    <T extends Table<T>> void select() throws SQLException {
        String totoIdAlias = "Toto_id";
        String totoAAlias = "Toto_a";
        String totoBAlias = "Toto_b";
        String totoQAlias = "Toto_q";
        String tataIdAlias = "Tata_id";
        InMemoryResultSet resultSetMock = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)7).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)tataIdAlias, (Object)7), Maps.asMap((Object)totoIdAlias, (Object)13).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)tataIdAlias, (Object)13), Maps.asMap((Object)totoIdAlias, (Object)17).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)tataIdAlias, (Object)17), Maps.asMap((Object)totoIdAlias, (Object)23).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)tataIdAlias, (Object)23)}));
        PreparedStatement preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
        Table totoTable = new Table("Toto");
        Column totoColId = totoTable.addColumn("id", Integer.class).primaryKey();
        PrimaryKey totoPrimaryKey = totoTable.getPrimaryKey();
        Column totoNameColumn = totoTable.addColumn("name", String.class);
        ValueAccessPointMap totoClassMapping = new ValueAccessPointMap();
        totoClassMapping.put(Accessors.propertyAccessor(Toto.class, (String)"id"), totoColId);
        DefaultEntityMapping totoMapping = new DefaultEntityMapping(Toto.class, totoTable, (Map)totoClassMapping, (ReversibleAccessor)Accessors.propertyAccessor(Toto.class, (String)"id"), (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Integer.class, c -> {}, c -> false));
        Table tataTable = new Table("Tata");
        Column tataColId = tataTable.addColumn("id", Integer.class);
        tataColId.primaryKey();
        PrimaryKey tataPrimaryKey = tataTable.getPrimaryKey();
        Column tataNameColumn = tataTable.addColumn("name", String.class);
        ValueAccessPointMap tataClassMapping = new ValueAccessPointMap();
        tataClassMapping.put(Accessors.propertyAccessor(Tata.class, (String)"id"), tataColId);
        DefaultEntityMapping tataMapping = new DefaultEntityMapping(Tata.class, totoTable, (Map)tataClassMapping, (ReversibleAccessor)Accessors.propertyAccessor(Tata.class, (String)"id"), (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Integer.class, c -> {}, c -> false));
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)totoMapping), (Fromable)totoMapping.getTargetTable());
        String tataAddKey = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMapping), (Accessor)Accessors.accessorByMethodReference(Toto::getTata), (Key)totoPrimaryKey, (Key)tataPrimaryKey, null, EntityJoinTree.JoinType.INNER, Toto::setTata, Collections.emptySet());
        ConnectionProvider connectionProvider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connectionProvider.giveConnection()).thenReturn((Object)connectionMock);
        Mockito.when((Object)connectionMock.prepareStatement((String)ArgumentMatchers.any())).thenReturn((Object)preparedStatement);
        AdvancedEntityPersister advancedEntityPersisterMock = (AdvancedEntityPersister)Mockito.mock(AdvancedEntityPersister.class);
        Mockito.when((Object)advancedEntityPersisterMock.getEntityJoinTree()).thenReturn((Object)entityJoinTree);
        Mockito.when((Object)advancedEntityPersisterMock.getMapping()).thenReturn((Object)totoMapping);
        RelationalEntityFinder testInstance = new RelationalEntityFinder(advancedEntityPersisterMock, connectionProvider, (Dialect)new DefaultDialect(), true);
        Set totos = testInstance.selectFromQueryBean("select Toto.id as Toto_id, Tata.id as Tata_id from Toto inner join Tata on Toto.id = Tata.id where Toto.id = :toto_id", (Map)Maps.asMap((Object)"toto_id", (Object)7));
        Toto expectedResult1 = new Toto(7, null, null);
        expectedResult1.setTata(new Tata(7));
        Toto expectedResult2 = new Toto(13, null, null);
        expectedResult2.setTata(new Tata(13));
        Toto expectedResult3 = new Toto(17, null, null);
        expectedResult3.setTata(new Tata(17));
        Toto expectedResult4 = new Toto(23, null, null);
        expectedResult4.setTata(new Tata(23));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)totos).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{expectedResult1, expectedResult2, expectedResult3, expectedResult4});
    }

    private static class Tata {
        private Integer id;
        private String prop1;

        public Tata() {
        }

        public Tata(Integer id) {
            this.id = id;
        }

        public Integer getId() {
            return this.id;
        }

        public String getProp1() {
            return this.prop1;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Maps.asMap((Object)"id", (Object)this.id).add((Object)"prop1", (Object)this.prop1) + "]";
        }
    }

    private static class Toto {
        private Integer id;
        private Integer a;
        private Integer b;
        private Integer x;
        private Integer y;
        private Integer z;
        private Set<Integer> q;
        private Tata tata;

        public Toto() {
        }

        public Toto(Integer id, Integer a, Integer b) {
            this(id, a, b, null, null, null);
        }

        public Toto(Integer id, Integer a, Integer b, Integer x, Integer y, Integer z) {
            this.id = id;
            this.a = a;
            this.b = b;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Toto(Integer a, Integer b, Integer x, Integer y, Integer z) {
            this.a = a;
            this.b = b;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Integer getId() {
            return this.id;
        }

        public Integer getA() {
            return this.a;
        }

        public void setQ(Set<Integer> q) {
            this.q = q;
        }

        public Set<Integer> getQ() {
            return this.q;
        }

        public void setTata(Tata tata) {
            this.tata = tata;
        }

        public Tata getTata() {
            return this.tata;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Maps.asMap((Object)"id", (Object)this.id).add((Object)"a", (Object)this.a).add((Object)"b", (Object)this.b).add((Object)"x", (Object)this.x).add((Object)"y", (Object)this.y).add((Object)"z", (Object)this.z).add((Object)"tata", (Object)this.tata) + "]";
        }
    }
}

