/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.lang.reflect.Field;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.reflection.AccessorByMethod;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.MutatorByField;
import org.codefilarete.reflection.MutatorByMethod;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.engine.configurer.PropertyAccessorResolver;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.tool.Reflections;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class PropertyAccessorResolverTest {
    PropertyAccessorResolverTest() {
    }

    public static Stream<Arguments> resolve() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{new PropertyMappingSupport(Country::getName, null, null), new AccessorByMethodReference(Country::getName), new MutatorByMethod(Reflections.findMethod(Country.class, (String)"setName", (Class[])new Class[]{String.class}))}), Arguments.arguments((Object[])new Object[]{new PropertyMappingSupport(null, Country::setName, null), new AccessorByMethod(Reflections.findMethod(Country.class, (String)"getName", (Class[])new Class[0])), new MutatorByMethodReference(Country::setName)}), Arguments.arguments((Object[])new Object[]{new PropertyMappingSupport(Country::getName, null, Reflections.findField(Country.class, (String)"name")), new AccessorByMethodReference(Country::getName), new MutatorByField(Reflections.findField(Country.class, (String)"name"))}), Arguments.arguments((Object[])new Object[]{new PropertyMappingSupport(null, Country::setName, Reflections.findField(Country.class, (String)"name")), new AccessorByField(Reflections.findField(Country.class, (String)"name")), new MutatorByMethodReference(Country::setName)}), Arguments.arguments((Object[])new Object[]{new PropertyMappingSupport(Country::hasNuclearPower, null, Reflections.findField(Country.class, (String)"hasNuclearPower")), new AccessorByMethodReference(Country::hasNuclearPower), new MutatorByField(Reflections.findField(Country.class, (String)"hasNuclearPower"))}), Arguments.arguments((Object[])new Object[]{new PropertyMappingSupport(null, Country::nuclearPower, Reflections.findField(Country.class, (String)"hasNuclearPower")), new AccessorByField(Reflections.findField(Country.class, (String)"hasNuclearPower")), new MutatorByMethodReference(Country::nuclearPower)}), Arguments.arguments((Object[])new Object[]{new PropertyMappingSupport(Country::hasNuclearPower, null, Reflections.findField(Country.class, (String)"hasNuclearPower")), new AccessorByMethodReference(Country::hasNuclearPower), new MutatorByField(Reflections.findField(Country.class, (String)"hasNuclearPower"))}));
    }

    @ParameterizedTest
    @MethodSource
    <C, O> void resolve(PropertyAccessorResolver.PropertyMapping<C, O> source, Accessor<C, O> expectedAccessor, Mutator<C, O> expectedMutator) {
        PropertyAccessorResolver testInstance = new PropertyAccessorResolver(source);
        PropertyAccessor actual = (PropertyAccessor)testInstance.resolve();
        Assertions.assertThat((Object)actual.getAccessor()).isEqualTo(expectedAccessor);
        Assertions.assertThat((Object)actual.getMutator()).isEqualTo(expectedMutator);
    }

    @Test
    void resolve_propertyDoesntMeetJavaBeanNamingConvention_exceptionIsThrown() {
        PropertyAccessorResolver testInstance = new PropertyAccessorResolver(new PropertyMappingSupport(Country::hasNuclearPower, null, null));
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> ((PropertyAccessorResolver)testInstance).resolve()).isInstanceOf(MappingConfigurationException.class)).hasMessage("Can't find a property matching getter name hasNuclearPower, setter can't be deduced, provide a field name to fix it").hasCauseInstanceOf(Reflections.MemberNotFoundException.class).hasRootCauseMessage("Field wrapper hasNuclearPower doesn't fit encapsulation naming convention");
        testInstance = new PropertyAccessorResolver(new PropertyMappingSupport(null, Country::nuclearPower, null));
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> ((PropertyAccessorResolver)testInstance).resolve()).isInstanceOf(MappingConfigurationException.class)).hasMessage("Can't find a property matching setter name nuclearPower, getter can't be deduced, provide a field name to fix it").hasCauseInstanceOf(Reflections.MemberNotFoundException.class).hasRootCauseMessage("Field wrapper nuclearPower doesn't fit encapsulation naming convention");
    }

    private static class PropertyMappingSupport<C, O>
    implements PropertyAccessorResolver.PropertyMapping<C, O> {
        private final SerializableFunction<C, O> getter;
        private final SerializableBiConsumer<C, O> setter;
        private final Field field;

        PropertyMappingSupport(SerializableFunction<C, O> getter, SerializableBiConsumer<C, O> setter, Field field) {
            this.getter = getter;
            this.setter = setter;
            this.field = field;
        }

        public SerializableFunction<C, O> getGetter() {
            return this.getter;
        }

        public SerializableBiConsumer<C, O> getSetter() {
            return this.setter;
        }

        public Field getField() {
            return this.field;
        }
    }
}

