/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.cascade;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.codefilarete.stalactite.engine.cascade.BeforeInsertSupport;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class BeforeInsertSupportTest {
    BeforeInsertSupportTest() {
    }

    @Test
    void constructorArgsAreInvoked() {
        Consumer actionMock = (Consumer)Mockito.mock(Consumer.class);
        Function targetProviderMock = (Function)Mockito.mock(Function.class);
        Mockito.when(targetProviderMock.apply(ArgumentMatchers.any())).thenAnswer(invocation -> ((String)invocation.getArgument(0)).toUpperCase());
        Predicate targetFilterMock = (Predicate)Mockito.mock(Predicate.class);
        Mockito.when((Object)targetFilterMock.test(ArgumentMatchers.any())).thenAnswer(invocation -> !"B".equals(invocation.getArgument(0)));
        BeforeInsertSupport testInstance = new BeforeInsertSupport(actionMock, targetProviderMock, targetFilterMock);
        testInstance.beforeInsert((Iterable)Arrays.asList((Object[])new String[]{"a", "b", "c"}));
        ((Consumer)Mockito.verify((Object)actionMock)).accept(ArgumentMatchers.eq((Object)Arrays.asHashSet((Object[])new String[]{"A", "C"})));
        ((Function)Mockito.verify((Object)targetProviderMock, (VerificationMode)Mockito.times((int)3))).apply(ArgumentMatchers.any());
        ((Predicate)Mockito.verify((Object)targetFilterMock, (VerificationMode)Mockito.times((int)3))).test(ArgumentMatchers.any());
    }

    @Test
    void constructorWithDefaultFilter_acceptAll() {
        Consumer actionMock = (Consumer)Mockito.mock(Consumer.class);
        Function targetProviderMock = (Function)Mockito.mock(Function.class);
        Mockito.when(targetProviderMock.apply(ArgumentMatchers.any())).thenAnswer(invocation -> ((String)invocation.getArgument(0)).toUpperCase());
        BeforeInsertSupport testInstance = new BeforeInsertSupport(actionMock, targetProviderMock);
        testInstance.beforeInsert((Iterable)Arrays.asList((Object[])new String[]{"a", "b", "c"}));
        ((Consumer)Mockito.verify((Object)actionMock)).accept(ArgumentMatchers.eq((Object)Arrays.asHashSet((Object[])new String[]{"A", "B", "C"})));
        ((Function)Mockito.verify((Object)targetProviderMock, (VerificationMode)Mockito.times((int)3))).apply(ArgumentMatchers.any());
    }
}

