/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.polymorphism;

import java.util.Map;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.RelationalMappingConfiguration;
import org.codefilarete.stalactite.dsl.subentity.SubEntityMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.RelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.polymorphism.PolymorphismBuilder;
import org.codefilarete.stalactite.engine.configurer.polymorphism.PolymorphismPersisterBuilder;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;

abstract class AbstractPolymorphicPersisterBuilder<C, I, T extends Table<T>>
implements PolymorphismBuilder<C, I, T> {
    protected final PolymorphismPolicy<C> polymorphismPolicy;
    protected final ConfiguredRelationalPersister<C, I> mainPersister;
    protected final AbstractIdentification<C, I> identification;
    protected final ColumnBinderRegistry columnBinderRegistry;
    protected final NamingConfiguration namingConfiguration;
    protected final PersisterBuilderContext persisterBuilderContext;

    protected AbstractPolymorphicPersisterBuilder(PolymorphismPolicy<C> polymorphismPolicy, AbstractIdentification<C, I> identification, ConfiguredRelationalPersister<C, I> mainPersister, ColumnBinderRegistry columnBinderRegistry, NamingConfiguration namingConfiguration, PersisterBuilderContext persisterBuilderContext) {
        this.polymorphismPolicy = polymorphismPolicy;
        this.identification = identification;
        this.mainPersister = mainPersister;
        this.columnBinderRegistry = columnBinderRegistry;
        this.namingConfiguration = namingConfiguration;
        this.persisterBuilderContext = persisterBuilderContext;
    }

    protected <D extends C> void registerSubEntitiesRelations(Map<Class<D>, ConfiguredRelationalPersister<D, I>> persisterPerSubclass, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        this.persisterBuilderContext.runInContext(this.mainPersister, () -> {
            for (SubEntityMappingConfiguration<C> subConfiguration : this.polymorphismPolicy.getSubClasses()) {
                ConfiguredRelationalPersister<C, I> subEntityPersister = (ConfiguredRelationalPersister<C, I>)persisterPerSubclass.get(subConfiguration.getEntityType());
                if (subConfiguration.getPolymorphismPolicy() != null) {
                    this.assertSubPolymorphismIsSupported(subConfiguration.getPolymorphismPolicy());
                    subEntityPersister = this.buildSubPolymorphicPersister(subEntityPersister, subConfiguration.getPolymorphismPolicy(), dialect, connectionConfiguration);
                    persisterPerSubclass.put(subConfiguration.getEntityType(), subEntityPersister);
                }
                this.registerRelationCascades(subConfiguration, dialect, connectionConfiguration, subEntityPersister);
            }
        });
    }

    abstract void assertSubPolymorphismIsSupported(PolymorphismPolicy<? extends C> var1);

    private <D extends C> ConfiguredRelationalPersister<D, I> buildSubPolymorphicPersister(ConfiguredRelationalPersister<D, I> subPersister, PolymorphismPolicy<D> subPolymorphismPolicy, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        PolymorphismPersisterBuilder polymorphismPersisterBuilder = new PolymorphismPersisterBuilder(subPolymorphismPolicy, (AbstractIdentification.SingleColumnIdentification)this.identification, subPersister, this.columnBinderRegistry, subPersister.getMapping().getPropertyToColumn(), subPersister.getMapping().getReadonlyPropertyToColumn(), subPersister.getMapping().getReadConverters(), subPersister.getMapping().getWriteConverters(), this.namingConfiguration, this.persisterBuilderContext);
        return polymorphismPersisterBuilder.build(dialect, connectionConfiguration);
    }

    private <D extends C> void registerRelationCascades(RelationalMappingConfiguration<D> entityMappingConfiguration, Dialect dialect, ConnectionConfiguration connectionConfiguration, ConfiguredRelationalPersister<D, I> subEntityPersister) {
        RelationConfigurer<D, I> relationConfigurer = new RelationConfigurer<D, I>(dialect, connectionConfiguration, subEntityPersister, this.namingConfiguration, this.persisterBuilderContext);
        relationConfigurer.configureRelations(entityMappingConfiguration);
    }
}

