/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manyToOne;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethod;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.MutatorByMethod;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.tool.Nullable;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class ManyToOneRelation<SRC, TRGT, TRGTID, C extends Collection<SRC>> {
    private final ReversibleAccessor<SRC, TRGT> targetProvider;
    private final EntityMappingConfigurationProvider<TRGT, TRGTID> targetMappingConfiguration;
    private final BooleanSupplier sourceTablePerClassPolymorphic;
    private boolean nullable = true;
    private CascadeOptions.RelationMode relationMode = CascadeOptions.RelationMode.ALL;
    private final MappedByConfiguration<SRC, TRGT, C> mappedByConfiguration = new MappedByConfiguration();
    private boolean fetchSeparately;
    @javax.annotation.Nullable
    private String columnName;
    private final MethodReferenceCapturer methodSpy = new MethodReferenceCapturer();

    public ManyToOneRelation(ReversibleAccessor<SRC, TRGT> targetProvider, BooleanSupplier sourceTablePerClassPolymorphic, EntityMappingConfigurationProvider<? extends TRGT, TRGTID> targetMappingConfiguration) {
        this.sourceTablePerClassPolymorphic = sourceTablePerClassPolymorphic;
        this.targetMappingConfiguration = targetMappingConfiguration;
        this.targetProvider = targetProvider;
    }

    public ReversibleAccessor<SRC, TRGT> getTargetProvider() {
        return this.targetProvider;
    }

    public boolean isSourceTablePerClassPolymorphic() {
        return this.sourceTablePerClassPolymorphic.getAsBoolean();
    }

    public EntityMappingConfiguration<TRGT, TRGTID> getTargetMappingConfiguration() {
        return this.targetMappingConfiguration.getConfiguration();
    }

    public boolean isTargetTablePerClassPolymorphic() {
        return this.getTargetMappingConfiguration().getPolymorphismPolicy() instanceof PolymorphismPolicy.TablePerClassPolymorphism;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public CascadeOptions.RelationMode getRelationMode() {
        return this.relationMode;
    }

    public void setRelationMode(CascadeOptions.RelationMode relationMode) {
        this.relationMode = relationMode;
    }

    public MappedByConfiguration<SRC, TRGT, C> getMappedByConfiguration() {
        return this.mappedByConfiguration;
    }

    public boolean isFetchSeparately() {
        return this.fetchSeparately;
    }

    public void setFetchSeparately(boolean fetchSeparately) {
        this.fetchSeparately = fetchSeparately;
    }

    public void fetchSeparately() {
        this.setFetchSeparately(true);
    }

    @javax.annotation.Nullable
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(@javax.annotation.Nullable String columnName) {
        this.columnName = columnName;
    }

    @javax.annotation.Nullable
    PropertyAccessor<TRGT, C> buildReversePropertyAccessor() {
        Nullable getterReference = Nullable.nullable(this.mappedByConfiguration.getAccessor()).map(Accessors::accessorByMethodReference);
        Nullable setterReference = Nullable.nullable(this.mappedByConfiguration.getMutator()).map(Accessors::mutatorByMethodReference);
        if (getterReference.isAbsent() && setterReference.isAbsent()) {
            return null;
        }
        if (getterReference.isPresent() && setterReference.isPresent()) {
            return new PropertyAccessor((Accessor)getterReference.get(), (Mutator)setterReference.get());
        }
        if (getterReference.isPresent() && setterReference.isAbsent()) {
            return new PropertyAccessor((Accessor)getterReference.get(), new AccessorByMethod(this.captureMethod(this.mappedByConfiguration.getAccessor())).toMutator());
        }
        return new PropertyAccessor(new MutatorByMethod(this.captureMethod(this.mappedByConfiguration.getMutator())).toAccessor(), (Mutator)setterReference.get());
    }

    private Method captureMethod(SerializableFunction getter) {
        return this.methodSpy.findMethod(getter);
    }

    private Method captureMethod(SerializableBiConsumer setter) {
        return this.methodSpy.findMethod(setter);
    }

    public <E, CC extends Collection<E>> ManyToOneRelation<E, TRGT, TRGTID, CC> embedInto(Accessor<E, SRC> accessor) {
        AccessorChain shiftedTargetProvider = new AccessorChain(new Accessor[]{accessor, this.targetProvider});
        ManyToOneRelation result = new ManyToOneRelation(shiftedTargetProvider, this::isSourceTablePerClassPolymorphic, this::getTargetMappingConfiguration);
        result.setRelationMode(this.getRelationMode());
        result.setNullable(this.isNullable());
        result.setFetchSeparately(this.isFetchSeparately());
        result.setColumnName(this.getColumnName());
        return result;
    }

    public static class MappedByConfiguration<SRC, TRGT, C2 extends Collection<SRC>> {
        @javax.annotation.Nullable
        private SerializableBiConsumer<TRGT, SRC> combiner;
        @javax.annotation.Nullable
        private SerializableFunction<TRGT, C2> accessor;
        @javax.annotation.Nullable
        private SerializableBiConsumer<TRGT, C2> mutator;
        @javax.annotation.Nullable
        private Supplier<C2> factory;

        @javax.annotation.Nullable
        public SerializableBiConsumer<TRGT, SRC> getCombiner() {
            return this.combiner;
        }

        public void setCombiner(@javax.annotation.Nullable SerializableBiConsumer<TRGT, SRC> combiner) {
            this.combiner = combiner;
        }

        @javax.annotation.Nullable
        public SerializableFunction<TRGT, C2> getAccessor() {
            return this.accessor;
        }

        public void setAccessor(@javax.annotation.Nullable SerializableFunction<TRGT, C2> accessor) {
            this.accessor = accessor;
        }

        @javax.annotation.Nullable
        public SerializableBiConsumer<TRGT, C2> getMutator() {
            return this.mutator;
        }

        public void setMutator(@javax.annotation.Nullable SerializableBiConsumer<TRGT, C2> mutator) {
            this.mutator = mutator;
        }

        @javax.annotation.Nullable
        public Supplier<C2> getFactory() {
            return this.factory;
        }

        public void setFactory(@javax.annotation.Nullable Supplier<C2> factory) {
            this.factory = factory;
        }

        public boolean isEmpty() {
            return this.accessor == null && this.mutator == null && this.factory == null && this.combiner == null;
        }
    }
}

