/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.builder.InheritanceMappingStep;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Hanger;

public class PrimaryKeyPropagationStep<C, I> {
    <T extends Table<T>> void propagate(PrimaryKey<T, I> primaryKey, InheritanceMappingStep.MappingPerTable<C> inheritanceMappingPerTable, ForeignKeyNamingStrategy foreignKeyNamingStrategy) {
        KeepOrderSet<Table> inheritanceTables = inheritanceMappingPerTable.giveTables();
        inheritanceTables.remove(primaryKey.getTable());
        PrimaryKeyPropagationStep.propagatePrimaryKey(primaryKey, inheritanceTables);
        ArrayList<Table> tables = new ArrayList<Table>((Collection<Table>)inheritanceTables);
        Collections.reverse(tables);
        this.applyForeignKeys(primaryKey, (Set<Table>)new KeepOrderSet(tables), foreignKeyNamingStrategy);
    }

    @VisibleForTesting
    void applyForeignKeys(PrimaryKey primaryKey, Set<Table> tables, ForeignKeyNamingStrategy foreignKeyNamingStrategy) {
        PrimaryKeyPropagationStep.applyForeignKeys(primaryKey, foreignKeyNamingStrategy, tables);
    }

    public static void propagatePrimaryKey(PrimaryKey<?, ?> primaryKey, Set<Table> tables) {
        Hanger.Holder previousPk = new Hanger.Holder(primaryKey);
        tables.forEach(t -> {
            ((PrimaryKey)previousPk.get()).getColumns().forEach(pkColumn -> {
                Column newColumn = t.addColumn(pkColumn.getName(), pkColumn.getJavaType(), pkColumn.getSize(), Boolean.valueOf(false));
                newColumn.primaryKey();
            });
            previousPk.set((Object)t.getPrimaryKey());
        });
    }

    public static void applyForeignKeys(PrimaryKey primaryKey, ForeignKeyNamingStrategy foreignKeyNamingStrategy, Set<Table> tables) {
        Hanger.Holder previousPk = new Hanger.Holder((Object)primaryKey);
        tables.forEach(t -> {
            PrimaryKey currentPrimaryKey = t.getPrimaryKey();
            t.addForeignKey(foreignKeyNamingStrategy.giveName(currentPrimaryKey, (Key)previousPk.get()), (Key)currentPrimaryKey, (Key)previousPk.get());
            previousPk.set((Object)currentPrimaryKey);
        });
    }
}

