/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.function.Function;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.idpolicy.AlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.dsl.idpolicy.BeforeInsertIdentifierPolicy;
import org.codefilarete.stalactite.dsl.idpolicy.BeforeInsertIdentifierPolicySupport;
import org.codefilarete.stalactite.dsl.idpolicy.DatabaseSequenceIdentifierPolicySupport;
import org.codefilarete.stalactite.dsl.idpolicy.GeneratedKeysPolicy;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.dsl.idpolicy.PooledHiLoSequenceIdentifierPolicySupport;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.builder.AbstractIdentificationStep;
import org.codefilarete.stalactite.engine.configurer.builder.InheritanceMappingStep;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.BeforeInsertIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.mapping.id.manager.JDBCGeneratedKeysIdentifierManager;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequence;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequenceOptions;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequencePersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Database;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;

public class IdentifierManagerStep<C, I>
extends AbstractIdentificationStep<C, I> {
    void applyIdentifierManager(AbstractIdentification<C, I> identification, InheritanceMappingStep.MappingPerTable<C> inheritanceMappingPerTable, ReversibleAccessor<C, I> idAccessor, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        this.determineIdentifierManager(identification, inheritanceMappingPerTable, idAccessor, dialect, connectionConfiguration);
    }

    private void determineIdentifierManager(AbstractIdentification<C, I> identification, InheritanceMappingStep.MappingPerTable<C> mappingPerTable, ReversibleAccessor<C, I> idAccessor, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        AccessorDefinition idDefinition = AccessorDefinition.giveDefinition(idAccessor);
        Class identifierType = idDefinition.getMemberType();
        AlreadyAssignedIdentifierManager identifierInsertionManager = null;
        if (identification instanceof AbstractIdentification.CompositeKeyIdentification) {
            identifierInsertionManager = new AlreadyAssignedIdentifierManager(identifierType, ((AbstractIdentification.CompositeKeyIdentification)identification).getMarkAsPersistedFunction(), ((AbstractIdentification.CompositeKeyIdentification)identification).getIsPersistedFunction());
        } else {
            IdentifierPolicy identifierPolicy = ((AbstractIdentification.SingleColumnIdentification)identification).getIdentifierPolicy();
            if (identifierPolicy instanceof GeneratedKeysPolicy) {
                Object targetTable = ((InheritanceMappingStep.Mapping)Iterables.first(mappingPerTable.getMappings())).getTargetTable();
                if (targetTable.getPrimaryKey().isComposed()) {
                    throw new UnsupportedOperationException("Composite primary key is not compatible with database-generated column");
                }
                Column primaryKey = (Column)Iterables.first((Iterable)targetTable.getPrimaryKey().getColumns());
                identifierInsertionManager = new JDBCGeneratedKeysIdentifierManager((IdAccessor)new AccessorWrapperIdAccessor(idAccessor), dialect.buildGeneratedKeysReader(primaryKey.getName(), primaryKey.getJavaType()), primaryKey.getJavaType());
            } else if (identifierPolicy instanceof BeforeInsertIdentifierPolicy) {
                PooledHiLoSequence sequence;
                if (identifierPolicy instanceof PooledHiLoSequenceIdentifierPolicySupport) {
                    Class entityType = identification.getIdentificationDefiner().getEntityType();
                    PooledHiLoSequenceOptions options = new PooledHiLoSequenceOptions(50, entityType.getSimpleName());
                    ConnectionProvider connectionProvider = connectionConfiguration.getConnectionProvider();
                    if (!(connectionProvider instanceof SeparateTransactionExecutor)) {
                        throw new MappingConfigurationException("Before-insert identifier policy configured with connection that doesn't support separate transaction, please provide a " + Reflections.toString(SeparateTransactionExecutor.class) + " as connection provider or change identifier policy");
                    }
                    sequence = new PooledHiLoSequence(options, new PooledHiLoSequencePersister(((PooledHiLoSequenceIdentifierPolicySupport)identifierPolicy).getStorageOptions(), dialect, (SeparateTransactionExecutor)connectionProvider, connectionConfiguration.getBatchSize()));
                } else if (identifierPolicy instanceof DatabaseSequenceIdentifierPolicySupport) {
                    Class entityType = identification.getIdentificationDefiner().getEntityType();
                    DatabaseSequenceIdentifierPolicySupport databaseSequenceSupport = (DatabaseSequenceIdentifierPolicySupport)identifierPolicy;
                    String sequenceName = databaseSequenceSupport.getDatabaseSequenceNamingStrategy().giveName(entityType);
                    Database database = new Database();
                    Database.Schema sequenceSchema = (Database.Schema)Nullable.nullable((Object)databaseSequenceSupport.getDatabaseSequenceSettings().getSchemaName()).map(s -> {
                        Database database2 = database;
                        database2.getClass();
                        return new Database.Schema(database2, s);
                    }).elseSet(() -> ((InheritanceMappingStep.Mapping)Iterables.first(mappingPerTable.getMappings())).getTargetTable().getSchema()).get();
                    Sequence databaseSequence = new Sequence(sequenceSchema, sequenceName).withBatchSize(databaseSequenceSupport.getDatabaseSequenceSettings().getBatchSize()).withInitialValue(databaseSequenceSupport.getDatabaseSequenceSettings().getInitialValue());
                    sequence = dialect.getDatabaseSequenceSelectorFactory().create(databaseSequence, connectionConfiguration.getConnectionProvider());
                } else if (identifierPolicy instanceof BeforeInsertIdentifierPolicySupport) {
                    sequence = ((BeforeInsertIdentifierPolicySupport)identifierPolicy).getSequence();
                } else {
                    throw new MappingConfigurationException("Before-insert identifier policy " + Reflections.toString(identifierPolicy.getClass()) + " is not supported");
                }
                identifierInsertionManager = new BeforeInsertIdentifierManager((IdAccessor)new AccessorWrapperIdAccessor(idAccessor), sequence, identifierType);
            } else if (identifierPolicy instanceof AlreadyAssignedIdentifierPolicy) {
                AlreadyAssignedIdentifierPolicy alreadyAssignedPolicy = (AlreadyAssignedIdentifierPolicy)identifierPolicy;
                identifierInsertionManager = new AlreadyAssignedIdentifierManager(identifierType, alreadyAssignedPolicy.getMarkAsPersistedFunction(), alreadyAssignedPolicy.getIsPersistedFunction());
            }
        }
        AlreadyAssignedIdentifierManager<C, I> fallbackMappingIdentifierManager = this.determineFallbackIdentifierManager((ReversibleAccessor)idAccessor, (IdentifierInsertionManager)identifierInsertionManager, identifierType);
        identification.setInsertionManager((IdentifierInsertionManager<C, I>)identifierInsertionManager).setFallbackInsertionManager(fallbackMappingIdentifierManager);
    }

    private <E> AlreadyAssignedIdentifierManager<E, I> determineFallbackIdentifierManager(ReversibleAccessor<E, I> idAccessor, IdentifierInsertionManager<E, I> identifierInsertionManager, Class<I> identifierType) {
        AlreadyAssignedIdentifierManager fallbackMappingIdentifierManager;
        if (identifierInsertionManager instanceof AlreadyAssignedIdentifierManager) {
            fallbackMappingIdentifierManager = new AlreadyAssignedIdentifierManager(identifierType, ((AlreadyAssignedIdentifierManager)identifierInsertionManager).getMarkAsPersistedFunction(), ((AlreadyAssignedIdentifierManager)identifierInsertionManager).getIsPersistedFunction());
        } else {
            Function<Object, Boolean> isPersistedFunction = identifierType.isPrimitive() ? c -> Reflections.PRIMITIVE_DEFAULT_VALUES.get(identifierType) == idAccessor.get(c) : c -> idAccessor.get(c) != null;
            fallbackMappingIdentifierManager = new AlreadyAssignedIdentifierManager(identifierType, c -> {}, isPersistedFunction);
        }
        return fallbackMappingIdentifierManager;
    }
}

