/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.model;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Timestamp {
    private Date creationDate;
    private Date modificationDate;
    private String readonlyProperty;

    public Timestamp() {
        this(new Date(), new Date());
    }

    public Timestamp(Date creationDate, Date modificationDate) {
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
    }

    public Timestamp(LocalDateTime creationDate, LocalDateTime modificationDate) {
        this.creationDate = Date.from(creationDate.atZone(ZoneId.systemDefault()).toInstant());
        this.modificationDate = Date.from(modificationDate.atZone(ZoneId.systemDefault()).toInstant());
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public String getReadonlyProperty() {
        return this.readonlyProperty;
    }

    public void setReadonlyProperty(String readonlyProperty) {
        this.readonlyProperty = readonlyProperty;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

