/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.transaction;

import java.sql.Connection;
import java.util.Set;
import javax.sql.DataSource;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.sql.CommitListener;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.RollbackListener;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.support.JdbcTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class StalactitePlatformTransactionManager
extends JdbcTransactionManager
implements ConnectionConfiguration.TransactionalConnectionProvider {
    private final Set<CommitListener> commitListeners = new KeepOrderSet();
    private final Set<RollbackListener> rollbackListeners = new KeepOrderSet();

    public StalactitePlatformTransactionManager(DataSource dataSource) {
        super(dataSource);
    }

    public void addCommitListener(CommitListener commitListener) {
        this.commitListeners.add(commitListener);
    }

    public void addRollbackListener(RollbackListener rollbackListener) {
        this.rollbackListeners.add(rollbackListener);
    }

    public Connection giveConnection() {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new IllegalStateException("No active transaction");
        }
        ConnectionHolder resource = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.getDataSource());
        if (resource == null) {
            throw new IllegalStateException("No connection available");
        }
        return resource.getConnection();
    }

    protected void prepareSynchronization(DefaultTransactionStatus status, TransactionDefinition definition) {
        super.prepareSynchronization(status, definition);
        if (status.isNewSynchronization()) {
            this.commitListeners.forEach(commitListener -> TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization((CommitListener)commitListener){
                final /* synthetic */ CommitListener val$commitListener;
                {
                    this.val$commitListener = commitListener;
                }

                public void beforeCommit(boolean readOnly) {
                    this.val$commitListener.beforeCommit();
                }

                public void afterCommit() {
                    this.val$commitListener.afterCommit();
                }
            }));
            this.rollbackListeners.forEach(rollbackListener -> TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization((RollbackListener)rollbackListener){
                final /* synthetic */ RollbackListener val$rollbackListener;
                {
                    this.val$rollbackListener = rollbackListener;
                }

                public void afterCompletion(int status) {
                    if (status == 1) {
                        this.val$rollbackListener.afterRollback();
                    }
                }
            }));
        }
    }

    public void executeInNewTransaction(final SeparateTransactionExecutor.JdbcOperation jdbcOperation) {
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)this);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                jdbcOperation.execute(StalactitePlatformTransactionManager.this.giveConnection());
            }
        });
    }
}

