/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.ExpandableSQLAppender;
import org.codefilarete.stalactite.query.builder.PreparableSQLBuilder;
import org.codefilarete.stalactite.query.builder.PreparedSQLAppender;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.builder.WhereSQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.Placeholder;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.UnitaryOperator;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Delete;
import org.codefilarete.stalactite.sql.order.MultiTableAwareDMLNameProvider;
import org.codefilarete.stalactite.sql.order.PlaceholderVariable;
import org.codefilarete.stalactite.sql.order.WherableStatement;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.trace.MutableInt;

public class DeleteCommandBuilder<T extends Table<T>>
implements SQLBuilder,
PreparableSQLBuilder {
    private final Delete<T> delete;
    private final Dialect dialect;
    private final MultiTableAwareDMLNameProvider dmlNameProvider;

    public DeleteCommandBuilder(Delete<T> delete, Dialect dialect) {
        this.delete = delete;
        this.dialect = dialect;
        this.dmlNameProvider = new MultiTableAwareDMLNameProvider(dialect.getDmlNameProviderFactory());
    }

    @Override
    public String toSQL() {
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        this.appendDeleteStatement(result, this.dmlNameProvider);
        return result.getSQL();
    }

    @Override
    public ExpandableSQLAppender toPreparableSQL() {
        ExpandableSQLAppender preparedSQLAppender = new ExpandableSQLAppender(this.dialect.getColumnBinderRegistry(), this.dmlNameProvider);
        this.appendDeleteStatement(preparedSQLAppender, this.dmlNameProvider);
        return preparedSQLAppender;
    }

    private void appendDeleteStatement(SQLAppender target, MultiTableAwareDMLNameProvider dmlNameProvider) {
        target.cat("delete from ", new String[0]);
        LinkedHashSet whereColumns = new LinkedHashSet();
        this.delete.getCriteria().forEach(c -> {
            if (c instanceof ColumnCriterion && ((ColumnCriterion)c).getColumn() instanceof Column) {
                whereColumns.add((Column)((ColumnCriterion)c).getColumn());
                Object condition = ((ColumnCriterion)c).getCondition();
                if (condition instanceof UnitaryOperator && ((UnitaryOperator)condition).getValue() instanceof ValuedVariable && ((ValuedVariable)((UnitaryOperator)condition).getValue()).getValue() instanceof Column) {
                    whereColumns.add((Column)((ValuedVariable)((UnitaryOperator)condition).getValue()).getValue());
                }
            }
        });
        Collection tablesInCondition = Iterables.collect(whereColumns, Column::getTable, HashSet::new);
        tablesInCondition.remove(this.delete.getTargetTable());
        Collection additionalTables = tablesInCondition;
        dmlNameProvider.setMultiTable(!additionalTables.isEmpty());
        target.cat(((Table)this.delete.getTargetTable()).getAbsoluteName(), new String[0]).catIf(dmlNameProvider.isMultiTable(), ", ");
        Iterator iterator = additionalTables.iterator();
        while (iterator.hasNext()) {
            Table next = (Table)iterator.next();
            target.cat(next.getAbsoluteName(), new String[0]).catIf(iterator.hasNext(), ", ");
        }
        if (this.delete.getCriteria().iterator().hasNext()) {
            target.cat(" where ", new String[0]);
            WhereSQLBuilderFactory.WhereSQLBuilder whereSqlBuilder = this.dialect.getQuerySQLBuilderFactory().getWhereBuilderFactory().whereBuilder(this.delete.getCriteria(), dmlNameProvider, this.dialect.getQuerySQLBuilderFactory());
            whereSqlBuilder.appendTo(target);
        }
    }

    public DeleteStatement<T> toStatement() {
        final MutableInt variableCounter = new MutableInt();
        final HashMap<String, Set<Integer>> placeholderIndexes = new HashMap<String, Set<Integer>>();
        PreparedSQLAppender statementAppender = new PreparedSQLAppender(new StringSQLAppender(this.dmlNameProvider), this.dialect.getColumnBinderRegistry()){

            @Override
            public <V> PreparedSQLAppender catValue(@Nullable Selectable<V> column, Object value) {
                SQLAppender result = super.catValue((Selectable)column, value);
                if (value instanceof Placeholder) {
                    placeholderIndexes.computeIfAbsent(((Placeholder)value).getName(), name -> new HashSet()).add(variableCounter.increment());
                }
                return result;
            }
        };
        this.appendDeleteStatement(statementAppender, this.dmlNameProvider);
        HashMap<Integer, Object> values = new HashMap<Integer, Object>(statementAppender.getValues());
        Map<Integer, ParameterBinder<?>> parameterBinders = statementAppender.getParameterBinders();
        for (PlaceholderVariable c : this.delete.getRow()) {
            Set indexes = (Set)placeholderIndexes.get(c.getName());
            if (indexes == null) {
                throw new IllegalArgumentException("No placeholder named \"" + c.getName() + "\" found in statement, available are " + placeholderIndexes.keySet());
            }
            indexes.forEach(index -> values.put((Integer)index, c.getValue()));
        }
        DeleteStatement result = new DeleteStatement(statementAppender.getSQL(), parameterBinders, placeholderIndexes);
        result.setValues(values);
        return result;
    }

    public static class DeleteStatement<T extends Table<T>>
    extends PreparedSQL
    implements WherableStatement {
        private final Map<String, Set<Integer>> placeholderIndexes;

        public DeleteStatement(String sql, Map<Integer, ? extends ParameterBinder<?>> parameterBinders, Map<String, Set<Integer>> placeholderIndexes) {
            super(sql, parameterBinders);
            this.placeholderIndexes = placeholderIndexes;
        }

        public void assertValuesAreApplyable() {
            super.assertValuesAreApplyable();
            Set presentPlaceholders = this.getValues().values().stream().filter(Placeholder.class::isInstance).map(Placeholder.class::cast).collect(Collectors.toSet());
            if (!presentPlaceholders.isEmpty()) {
                throw new IllegalStateException("Statement expect values for placeholders: " + presentPlaceholders.stream().map(Placeholder::getName).collect(Collectors.joining(", ")));
            }
        }

        public <C> void setValue(String placeholderName, C value) {
            Set<Integer> placeholderIndex = this.placeholderIndexes.get(placeholderName);
            if (placeholderIndex == null) {
                throw new IllegalArgumentException("Placeholder '" + placeholderName + "' is not declared as a criteria in the where clause");
            }
            placeholderIndex.forEach(index -> this.setValue(index, value));
        }
    }
}

