/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.OperatorSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.WhereSQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Criteria;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class WhereSQLBuilderTest {
    public static Object[][] toSQL_data() {
        Table tableToto = new Table(null, "Toto");
        Column colA = tableToto.addColumn("a", String.class);
        Column colB = tableToto.addColumn("b", String.class);
        Maps.ChainingMap tableAliases = Maps.asMap((Object)tableToto, (Object)"t");
        return new Object[][]{{QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)"28")), Collections.EMPTY_MAP, "Toto.a = '28'"}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)"28")).and(colB, (ConditionalOperator)Operators.eq((Object)"1")), Collections.EMPTY_MAP, "Toto.a = '28' and Toto.b = '1'"}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)"28")).and((CriteriaChain)QueryEase.filter((Selectable)colB, (ConditionalOperator)Operators.eq((Object)"1"))), Collections.EMPTY_MAP, "Toto.a = '28' and (Toto.b = '1')"}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)"o'clock")).and((CriteriaChain)QueryEase.filter((Selectable)colB, (ConditionalOperator)Operators.eq((Object)"o'clock"))), Collections.EMPTY_MAP, "Toto.a = 'o''clock' and (Toto.b = 'o''clock')"}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.like((CharSequence)"o'clock")).and((CriteriaChain)QueryEase.filter((Selectable)colB, (ConditionalOperator)Operators.like((CharSequence)"o'clock"))), Collections.EMPTY_MAP, "Toto.a like 'o''clock' and (Toto.b like 'o''clock')"}, {QueryEase.where((Selectable)colA, (String)"= 28").and(colB, (CharSequence)"= 1"), Collections.EMPTY_MAP, "Toto.a = 28 and Toto.b = 1"}, {QueryEase.where((Selectable)colA, (String)"= 28").or(colB, (CharSequence)"= 1"), Collections.EMPTY_MAP, "Toto.a = 28 or Toto.b = 1"}, {QueryEase.where((Selectable)colA, (String)"= 28").and(colB, (CharSequence)"= 1"), tableAliases, "t.a = 28 and t.b = 1"}, {QueryEase.where((Selectable)colA, (String)"= 28").or(colB, (CharSequence)"= 1"), tableAliases, "t.a = 28 or t.b = 1"}, {QueryEase.filter((Selectable)colA, (String)"= 28").and(colB, (CharSequence)"= 1"), tableAliases, "t.a = 28 and t.b = 1"}, {QueryEase.filter((Selectable)colA, (String)"= 28").or(colB, (CharSequence)"= 1"), tableAliases, "t.a = 28 or t.b = 1"}, {QueryEase.where((Selectable)colA, (String)"= 28").and((CriteriaChain)QueryEase.filter((Selectable)colB, (String)"= 1")), tableAliases, "t.a = 28 and (t.b = 1)"}, {QueryEase.where((Selectable)colA, (String)"= 28").or((CriteriaChain)QueryEase.filter((Selectable)colB, (String)"= 1")), tableAliases, "t.a = 28 or (t.b = 1)"}, {QueryEase.where((Selectable)colA, (String)"= 28").or(QueryEase.filter((Selectable)colB, (String)"= 1").and(colB, (CharSequence)"< -1")), tableAliases, "t.a = 28 or (t.b = 1 and t.b < -1)"}, {QueryEase.where((Selectable)colA, (String)"= 28").or(QueryEase.filter((Selectable)colB, (String)"= 1").or(colB, (CharSequence)"< -1")), tableAliases, "t.a = 28 or (t.b = 1 or t.b < -1)"}, {QueryEase.where((Selectable)colA, (String)"= 28").or(((Criteria)QueryEase.filter((Selectable)colB, (String)"= 1").and(colB, (CharSequence)"< -1")).and((CriteriaChain)QueryEase.filter((Selectable)colA, (String)"= 42"))), tableAliases, "t.a = 28 or (t.b = 1 and t.b < -1 and (t.a = 42))"}, {QueryEase.where((Selectable)colA, (String)"= 28").or(((Criteria)QueryEase.filter((Selectable)colB, (String)"= 1").and(colB, (CharSequence)"< -1")).or((CriteriaChain)QueryEase.filter((Selectable)colA, (String)"= 42"))), tableAliases, "t.a = 28 or (t.b = 1 and t.b < -1 or (t.a = 42))"}, {QueryEase.where((Selectable)colA, (String)"= 28").or(QueryEase.filter((Object[])new Object[]{"t.b = 1"}).and(new Object[]{"t.b < -1"})), tableAliases, "t.a = 28 or (t.b = 1 and t.b < -1)"}, {QueryEase.where((Selectable)colA, (String)"= 28").or(QueryEase.filter((Object[])new Object[]{"t.b = 1"}).or(new Object[]{"t.b < -1"})), tableAliases, "t.a = 28 or (t.b = 1 or t.b < -1)"}, {QueryEase.where((Selectable)colA, (String)"= 28").or(QueryEase.filter((Object[])new Object[]{"t.b = 1"}).or(colB, (ConditionalOperator)Operators.eq((Object)colA))), tableAliases, "t.a = 28 or (t.b = 1 or t.b = t.a)"}};
    }

    @ParameterizedTest
    @MethodSource(value={"toSQL_data"})
    public void toSQL(CriteriaChain where, Map<Table, String> tableAliases, String expected) {
        DMLNameProvider dmlNameProvider = new DMLNameProvider(tableAliases);
        FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder = new FunctionSQLBuilderFactory.FunctionSQLBuilder(dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        WhereSQLBuilderFactory.WhereSQLBuilder testInstance = new WhereSQLBuilderFactory.WhereSQLBuilder(where, dmlNameProvider, new ColumnBinderRegistry(), new OperatorSQLBuilderFactory.OperatorSQLBuilder(functionSQLBuilder, null), functionSQLBuilder);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo(expected);
    }

    public static Object[][] toPreparableSQL_data() {
        Table tableToto = new Table(null, "Toto");
        Column colA = tableToto.addColumn("a", String.class);
        Column colB = tableToto.addColumn("b", String.class);
        Maps.ChainingMap tableAliases = Maps.asMap((Object)tableToto, (Object)"t");
        return new Object[][]{{QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).and(colB, (ConditionalOperator)Operators.eq((Object)1)), Collections.EMPTY_MAP, "Toto.a = ? and Toto.b = ?", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).or(colB, (ConditionalOperator)Operators.eq((Object)1)), Collections.EMPTY_MAP, "Toto.a = ? or Toto.b = ?", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).and(colB, (ConditionalOperator)Operators.eq((Object)1)), tableAliases, "t.a = ? and t.b = ?", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).or(colB, (ConditionalOperator)Operators.eq((Object)1)), tableAliases, "t.a = ? or t.b = ?", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1)}, {QueryEase.filter((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).and(colB, (ConditionalOperator)Operators.eq((Object)1)), tableAliases, "t.a = ? and t.b = ?", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1)}, {QueryEase.filter((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).or(colB, (ConditionalOperator)Operators.eq((Object)1)), tableAliases, "t.a = ? or t.b = ?", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).and((CriteriaChain)QueryEase.filter((Selectable)colB, (ConditionalOperator)Operators.eq((Object)1))), tableAliases, "t.a = ? and (t.b = ?)", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).or((CriteriaChain)QueryEase.filter((Selectable)colB, (ConditionalOperator)Operators.eq((Object)1))), tableAliases, "t.a = ? or (t.b = ?)", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).or(QueryEase.filter((Selectable)colB, (ConditionalOperator)Operators.eq((Object)1)).and(colB, (ConditionalOperator)Operators.lt((Object)-1))), tableAliases, "t.a = ? or (t.b = ? and t.b < ?)", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1).add((Object)3, (Object)-1)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).or(QueryEase.filter((Selectable)colB, (ConditionalOperator)Operators.eq((Object)1)).or(colB, (ConditionalOperator)Operators.lt((Object)-1))), tableAliases, "t.a = ? or (t.b = ? or t.b < ?)", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1).add((Object)3, (Object)-1)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).or(((Criteria)QueryEase.filter((Selectable)colB, (ConditionalOperator)Operators.eq((Object)1)).and(colB, (ConditionalOperator)Operators.lt((Object)-1))).and((CriteriaChain)QueryEase.filter((Selectable)colA, (ConditionalOperator)Operators.eq((Object)42)))), tableAliases, "t.a = ? or (t.b = ? and t.b < ? and (t.a = ?))", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1).add((Object)3, (Object)-1).add((Object)4, (Object)42)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).or(((Criteria)QueryEase.filter((Selectable)colB, (ConditionalOperator)Operators.eq((Object)1)).and(colB, (ConditionalOperator)Operators.lt((Object)-1))).or((CriteriaChain)QueryEase.filter((Selectable)colA, (ConditionalOperator)Operators.eq((Object)42)))), tableAliases, "t.a = ? or (t.b = ? and t.b < ? or (t.a = ?))", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1).add((Object)3, (Object)-1).add((Object)4, (Object)42)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).or(QueryEase.filter((Selectable)colB, (ConditionalOperator)Operators.eq((Object)1)).and(colB, (ConditionalOperator)Operators.lt((Object)-1))), tableAliases, "t.a = ? or (t.b = ? and t.b < ?)", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1).add((Object)3, (Object)-1)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)).or(QueryEase.filter((Selectable)colB, (ConditionalOperator)Operators.eq((Object)1)).or(colB, (ConditionalOperator)Operators.lt((Object)-1))), tableAliases, "t.a = ? or (t.b = ? or t.b < ?)", Maps.asHashMap((Object)1, (Object)28).add((Object)2, (Object)1).add((Object)3, (Object)-1)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq((Object)28)), Collections.EMPTY_MAP, "Toto.a = ?", Maps.asHashMap((Object)1, (Object)28)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.between((Object)10, (Object)20)), Collections.EMPTY_MAP, "Toto.a between ? and ?", Maps.asHashMap((Object)1, (Object)10).add((Object)2, (Object)20)}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.eq(null)), Collections.EMPTY_MAP, "Toto.a is null", Collections.EMPTY_MAP}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.between((Object)"1", null)), Collections.EMPTY_MAP, "Toto.a > ?", Maps.asHashMap((Object)1, (Object)"1")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.between(null, (Object)"2")), Collections.EMPTY_MAP, "Toto.a < ?", Maps.asHashMap((Object)1, (Object)"2")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.not((ConditionalOperator)Operators.between((Object)"1", (Object)"2"))), Collections.EMPTY_MAP, "Toto.a not between ? and ?", Maps.asHashMap((Object)1, (Object)"1").add((Object)2, (Object)"2")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.not((ConditionalOperator)Operators.between(null, null))), Collections.EMPTY_MAP, "Toto.a is not null", Collections.EMPTY_MAP}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.not((ConditionalOperator)Operators.between((Object)"1", null))), Collections.EMPTY_MAP, "Toto.a <= ?", Maps.asHashMap((Object)1, (Object)"1")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.not((ConditionalOperator)Operators.between(null, (Object)"2"))), Collections.EMPTY_MAP, "Toto.a >= ?", Maps.asHashMap((Object)1, (Object)"2")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.lt((Object)"1")), Collections.EMPTY_MAP, "Toto.a < ?", Maps.asHashMap((Object)1, (Object)"1")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.gt((Object)"1")), Collections.EMPTY_MAP, "Toto.a > ?", Maps.asHashMap((Object)1, (Object)"1")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.lteq((Object)"1")), Collections.EMPTY_MAP, "Toto.a <= ?", Maps.asHashMap((Object)1, (Object)"1")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.gteq((Object)"1")), Collections.EMPTY_MAP, "Toto.a >= ?", Maps.asHashMap((Object)1, (Object)"1")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.not((ConditionalOperator)Operators.lteq((Object)"1"))), Collections.EMPTY_MAP, "Toto.a > ?", Maps.asHashMap((Object)1, (Object)"1")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.not((ConditionalOperator)Operators.gteq((Object)"1"))), Collections.EMPTY_MAP, "Toto.a < ?", Maps.asHashMap((Object)1, (Object)"1")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.like((CharSequence)"x")), Collections.EMPTY_MAP, "Toto.a like ?", Maps.asHashMap((Object)1, (Object)"x")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.startsWith((CharSequence)"x")), Collections.EMPTY_MAP, "Toto.a like ?", Maps.asHashMap((Object)1, (Object)"x%")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.endsWith((CharSequence)"x")), Collections.EMPTY_MAP, "Toto.a like ?", Maps.asHashMap((Object)1, (Object)"%x")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.not((ConditionalOperator)Operators.like((CharSequence)"x"))), Collections.EMPTY_MAP, "Toto.a not like ?", Maps.asHashMap((Object)1, (Object)"x")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.not((ConditionalOperator)Operators.startsWith((CharSequence)"x"))), Collections.EMPTY_MAP, "Toto.a not like ?", Maps.asHashMap((Object)1, (Object)"x%")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.not((ConditionalOperator)Operators.endsWith((CharSequence)"x"))), Collections.EMPTY_MAP, "Toto.a not like ?", Maps.asHashMap((Object)1, (Object)"%x")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.in((Object[])new String[]{"x"})), Collections.EMPTY_MAP, "Toto.a in (?)", Maps.asHashMap((Object)1, (Object)"x")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.in((Object[])new String[]{"x", "y"})), Collections.EMPTY_MAP, "Toto.a in (?, ?)", Maps.asHashMap((Object)1, (Object)"x").add((Object)2, (Object)"y")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.not((ConditionalOperator)Operators.in((Object[])new String[]{"x"}))), Collections.EMPTY_MAP, "Toto.a not in (?)", Maps.asHashMap((Object)1, (Object)"x")}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.in((Iterable)null)), Collections.EMPTY_MAP, "Toto.a is null", Collections.EMPTY_MAP}, {QueryEase.where((Selectable)colA, (ConditionalOperator)Operators.in((Iterable)Arrays.asSet((Object[])new String[]{"x", "y"}))), Collections.EMPTY_MAP, "Toto.a in (?, ?)", Maps.asHashMap((Object)1, (Object)"x").add((Object)2, (Object)"y")}};
    }

    @ParameterizedTest(name="{2} - [{index}]")
    @MethodSource(value={"toPreparableSQL_data"})
    public void toPreparableSQL(CriteriaChain where, Map<Table, String> tableAliases, String expectedPreparedStatement, Map<Integer, Object> expectedValues) {
        DMLNameProvider dmlNameProvider = new DMLNameProvider(tableAliases);
        FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder = new FunctionSQLBuilderFactory.FunctionSQLBuilder(dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        WhereSQLBuilderFactory.WhereSQLBuilder testInstance = new WhereSQLBuilderFactory.WhereSQLBuilder(where, dmlNameProvider, new ColumnBinderRegistry(), new OperatorSQLBuilderFactory.OperatorSQLBuilder(functionSQLBuilder, null), functionSQLBuilder);
        PreparedSQL preparedSQL = testInstance.toPreparableSQL().toPreparedSQL(new HashMap());
        Assertions.assertThat((String)preparedSQL.getSQL()).isEqualTo(expectedPreparedStatement);
        Assertions.assertThat((Map)preparedSQL.getValues()).isEqualTo(expectedValues);
    }
}

