/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.statement.binder.AbstractParameterBindersITTest;
import org.codefilarete.stalactite.sql.statement.binder.OracleParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.OracleTypeMapping;
import org.codefilarete.stalactite.sql.test.DatabaseHelper;
import org.codefilarete.stalactite.sql.test.OracleDatabaseHelper;
import org.codefilarete.stalactite.sql.test.OracleTestDataSourceSelector;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OracleParameterBindersTest
extends AbstractParameterBindersITTest {
    private static final DataSource DATASOURCE = new OracleTestDataSourceSelector().giveDataSource();

    public DataSource giveDataSource() {
        return DATASOURCE;
    }

    protected DatabaseHelper giveDatabaseHelper() {
        return new OracleDatabaseHelper();
    }

    @BeforeEach
    void createParameterBinderRegistry() {
        this.parameterBinderRegistry = new OracleParameterBinderRegistry();
    }

    @BeforeEach
    void createJavaTypeToSqlTypeMapping() {
        this.javaTypeToSqlTypeMapping = new OracleTypeMapping();
    }

    @Test
    void localDateTimeBinder() throws SQLException {
        LocalDateTime initialTime = LocalDateTime.of(2021, Month.JULY, 12, 4, 23, 35, 123456789);
        LocalDateTime comparisonTime = LocalDateTime.of(2021, Month.JULY, 12, 4, 23, 35, 123457000);
        Set databaseContent = this.insertAndSelect(LocalDateTime.class, Arrays.asSet((Object[])new LocalDateTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new LocalDateTime[]{null, comparisonTime}));
    }

    @Test
    void localTimeBinder() throws SQLException {
        LocalTime initialTime = LocalTime.of(4, 23, 35, 123456789);
        LocalTime comparisonTime = LocalTime.of(4, 23, 35, 123457000);
        Set databaseContent = this.insertAndSelect(LocalTime.class, Arrays.asSet((Object[])new LocalTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new LocalTime[]{null, comparisonTime}));
    }

    @Test
    void zonedDateTimeBinder() throws SQLException {
        ZonedDateTime initialTime = ZonedDateTime.of(2024, 6, 18, 11, 22, 33, 123456789, ZoneOffset.ofHours(5));
        ZonedDateTime comparisonTime = ZonedDateTime.of(2024, 6, 18, 11, 22, 33, 123457000, ZoneOffset.ofHours(5));
        Set databaseContent = this.insertAndSelect(ZonedDateTime.class, Arrays.asSet((Object[])new ZonedDateTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new ZonedDateTime[]{null, comparisonTime}));
    }

    @Test
    void offsetDateTimeBinder() throws SQLException {
        OffsetDateTime initialTime = OffsetDateTime.of(2024, 6, 18, 11, 22, 33, 123456789, ZoneOffset.ofHours(5));
        OffsetDateTime comparisonTime = OffsetDateTime.of(2024, 6, 18, 11, 22, 33, 123457000, ZoneOffset.ofHours(5));
        Set databaseContent = this.insertAndSelect(OffsetDateTime.class, Arrays.asSet((Object[])new OffsetDateTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new OffsetDateTime[]{null, comparisonTime}));
    }
}

