/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.crud;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import java.util.stream.LongStream;
import org.codefilarete.stalactite.engine.crud.BatchDelete;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Delete;
import org.codefilarete.stalactite.sql.order.DeleteCommandBuilder;
import org.codefilarete.stalactite.sql.order.PlaceholderVariable;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.tool.collection.KeepOrderSet;

public class DefaultBatchDelete<T extends Table<T>>
implements BatchDelete<T> {
    private final Delete<T> statement;
    private final Deque<Set<? extends PlaceholderVariable<?, T>>> rows = new ArrayDeque();
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;
    private DeleteCommandBuilder.DeleteStatement<T> deleteStatement;

    public DefaultBatchDelete(Delete<T> statement, Dialect dialect, ConnectionProvider connectionProvider) {
        this.statement = statement;
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
        this.rows.add(statement.getRow());
    }

    @Override
    public DefaultBatchDelete<T> newRow() {
        this.rows.addLast((Set<PlaceholderVariable<?, T>>)new KeepOrderSet());
        return this;
    }

    @Override
    public <C> DefaultBatchDelete<T> set(String paramName, C value) {
        this.giveCurrentRow().add(new PlaceholderVariable(paramName, value));
        return this;
    }

    private Set<PlaceholderVariable<?, T>> giveCurrentRow() {
        return this.rows.getLast();
    }

    @Override
    public long execute() {
        long[] writeCount;
        if (this.deleteStatement == null) {
            this.deleteStatement = new DeleteCommandBuilder<T>(this.statement, this.dialect).toStatement();
        }
        try (WriteOperation<T> writeOperation = this.dialect.getWriteOperationFactory().createInstance(this.deleteStatement, this.connectionProvider);){
            this.rows.forEach(row -> {
                row.forEach(c -> c.applyValueTo(this.deleteStatement));
                writeOperation.addBatch(this.deleteStatement.getValues());
            });
            writeCount = writeOperation.executeBatch();
        }
        this.rows.clear();
        this.rows.add((Set<PlaceholderVariable<?, T>>)new KeepOrderSet());
        return LongStream.of(writeCount).sum();
    }
}

