/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.trace.MutableInt;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ReadOperationTest {
    ReadOperationTest() {
    }

    @Test
    void execute_preparedSQL() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)preparedStatementMock);
        HashMap<Integer, ParameterBinder> parameterBinders = new HashMap<Integer, ParameterBinder>();
        parameterBinders.put(1, DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put(2, DefaultParameterBinders.STRING_BINDER);
        ReadOperation testInstance = new ReadOperation((SQLStatement)new PreparedSQL("select count(*) from Toto where id = ? and name = ?", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock));
        testInstance.setValue((Object)1, (Object)1L);
        testInstance.setValue((Object)2, (Object)"tata");
        testInstance.execute();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 1L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeQuery();
    }

    @Test
    void execute_parameterizedSQL() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)preparedStatementMock);
        HashMap<String, ParameterBinder> parameterBinders = new HashMap<String, ParameterBinder>();
        parameterBinders.put("id", DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put("name", DefaultParameterBinders.STRING_BINDER);
        ReadOperation testInstance = new ReadOperation((SQLStatement)new StringParamedSQL("select count(*) from Toto where id = :id and name = :name", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock));
        testInstance.setValue((Object)"id", (Object)1L);
        testInstance.setValue((Object)"name", (Object)"tata");
        testInstance.execute();
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(1, 1L);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setString(2, "tata");
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeQuery();
    }

    @Test
    void setValue_listenerIsCalled() throws SQLException {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn(Mockito.mock(PreparedStatement.class));
        HashMap<String, ParameterBinder> parameterBinders = new HashMap<String, ParameterBinder>();
        parameterBinders.put("id", DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        parameterBinders.put("name", DefaultParameterBinders.STRING_BINDER);
        final MutableInt beforeValuesSetInvokationCount = new MutableInt();
        final HashMap capturedValues = new HashMap();
        ReadOperation testInstance = new ReadOperation((SQLStatement)new StringParamedSQL("select count(*) from Toto where id = :id and name = :name", parameterBinders), (ConnectionProvider)new SimpleConnectionProvider(connectionMock));
        testInstance.setListener((SQLOperation.SQLOperationListener)new SQLOperation.SQLOperationListener<String>(){

            public void onValuesSet(Map<String, ?> values) {
                beforeValuesSetInvokationCount.increment();
            }

            public void onValueSet(String param, Object value) {
                capturedValues.put(param, value);
            }
        });
        testInstance.setValue((Object)"id", (Object)1L);
        testInstance.setValue((Object)"name", (Object)"tata");
        Assertions.assertThat((int)beforeValuesSetInvokationCount.getValue()).isEqualTo(0);
        Assertions.assertThat(capturedValues).isEqualTo((Object)Maps.asHashMap((Object)"id", (Object)1L).add((Object)"name", (Object)"tata"));
    }
}

