/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.jointable;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.stalactite.engine.DeleteExecutor;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EntityMappingWrapper;
import org.codefilarete.stalactite.engine.runtime.FirstPhaseRelationLoader;
import org.codefilarete.stalactite.engine.runtime.PersisterWrapper;
import org.codefilarete.stalactite.engine.runtime.PolymorphicPersister;
import org.codefilarete.stalactite.engine.runtime.RelationIds;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.SecondPhaseRelationLoader;
import org.codefilarete.stalactite.engine.runtime.jointable.JoinTablePolymorphismEntityFinder;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinTablePolymorphicRelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.MergeJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.PolymorphicMergeJoinRowConsumer;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Hanger;

public class JoinTablePolymorphismPersister<C, I>
extends AbstractPolymorphismPersister<C, I> {
    private static final ThreadLocal<Queue<Set<RelationIds<Object, Object, Object>>>> CURRENT_2PHASES_LOAD_CONTEXT = new ThreadLocal();
    private final Map<Class<? extends C>, IdMapping<C, I>> subclassIdMappingStrategies;
    private final Map<Class<? extends C>, Table> tablePerSubEntityType;
    private final PrimaryKey<?, I> mainTablePrimaryKey;

    public JoinTablePolymorphismPersister(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> subEntitiesPersisters, ConnectionProvider connectionProvider, Dialect dialect) {
        super(mainPersister, subEntitiesPersisters, new JoinTablePolymorphismEntityFinder(mainPersister, subEntitiesPersisters, connectionProvider, dialect));
        Table mainTable = mainPersister.getMapping().getTargetTable();
        this.mainTablePrimaryKey = mainTable.getPrimaryKey();
        Set<Map.Entry<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>>> subPersisterPerSubEntityType = subEntitiesPersisters.entrySet();
        Map subclassSelectExecutors = Iterables.map(subPersisterPerSubEntityType, Map.Entry::getKey, Map.Entry::getValue, KeepOrderMap::new);
        this.subclassIdMappingStrategies = Iterables.map(subPersisterPerSubEntityType, Map.Entry::getKey, e -> ((ConfiguredRelationalPersister)e.getValue()).getMapping().getIdMapping());
        this.tablePerSubEntityType = Iterables.map(this.subEntitiesPersisters.entrySet(), Map.Entry::getKey, entry -> ((ConfiguredRelationalPersister)entry.getValue()).getMapping().getTargetTable(), KeepOrderMap::new);
    }

    @Override
    public <LEFTTABLE extends Table<LEFTTABLE>, SUBTABLE extends Table<SUBTABLE>, JOINTYPE> void propagateMappedAssociationToSubTables(Key<SUBTABLE, JOINTYPE> foreignKey, PrimaryKey<LEFTTABLE, JOINTYPE> leftPrimaryKey, BiFunction<Key<SUBTABLE, JOINTYPE>, PrimaryKey<LEFTTABLE, JOINTYPE>, String> foreignKeyNamingFunction) {
        Object mainTable = this.mainPersister.getMainTable();
        Key.KeyBuilder projectedKeyBuilder = Key.from(mainTable);
        foreignKey.getColumns().forEach(column -> projectedKeyBuilder.addColumn((JoinLink)mainTable.addColumn(column.getName(), column.getJavaType(), column.getSize(), column.getNullable())));
        Key projectedKey = projectedKeyBuilder.build();
        this.mainPersister.getEntityJoinTree().addPassiveJoin("ROOT", foreignKey, projectedKey, EntityJoinTree.JoinType.INNER, java.util.Collections.emptySet());
        mainTable.addForeignKey(foreignKeyNamingFunction, projectedKey, leftPrimaryKey);
    }

    @Override
    public Set<Class<? extends C>> getSupportedEntityTypes() {
        HashSet result = new HashSet();
        this.subEntitiesPersisters.forEach((c, p) -> {
            if (p instanceof PolymorphicPersister) {
                result.addAll(((PolymorphicPersister)((Object)p)).getSupportedEntityTypes());
            } else if (p instanceof PersisterWrapper && ((PersisterWrapper)p).getDeepestDelegate() instanceof PolymorphicPersister) {
                result.addAll(((PolymorphicPersister)((Object)((PersisterWrapper)p).getDeepestDelegate())).getSupportedEntityTypes());
            } else {
                result.add((Class)c);
            }
        });
        return result;
    }

    public Collection<Table<?>> giveImpliedTables() {
        List subTables = this.subEntitiesPersisters.values().stream().flatMap(p -> p.giveImpliedTables().stream()).collect(Collectors.toList());
        return Collections.cat((Collection[])new Collection[]{this.mainPersister.giveImpliedTables(), subTables});
    }

    public void doInsert(Iterable<? extends C> entities) {
        this.mainPersister.insert(entities);
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(InsertExecutor::insert);
    }

    public void doUpdateById(Iterable<? extends C> entities) {
        this.mainPersister.updateById(entities);
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(UpdateExecutor::updateById);
    }

    public void doUpdate(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        this.mainPersister.update(differencesIterable, allColumnsStatement);
        KeepOrderMap entitiesPerType = new KeepOrderMap();
        differencesIterable.forEach(arg_0 -> this.lambda$doUpdate$7((Map)entitiesPerType, arg_0));
        entitiesPerType.forEach((updateExecutor, adhocEntities) -> updateExecutor.update((Iterable)adhocEntities, allColumnsStatement));
    }

    public void doDelete(Iterable<? extends C> entities) {
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(DeleteExecutor::delete);
        this.mainPersister.delete(entities);
    }

    public void doDeleteById(Iterable<? extends C> entities) {
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(DeleteExecutor::deleteById);
        this.mainPersister.deleteById(entities);
    }

    private Map<EntityPersister<C, I>, Set<C>> computeEntitiesPerPersister(Iterable<? extends C> entities) {
        KeepOrderMap entitiesPerType = new KeepOrderMap();
        entities.forEach(arg_0 -> this.lambda$computeEntitiesPerPersister$11((Map)entitiesPerType, arg_0));
        return entitiesPerType;
    }

    @Override
    public <E, ID> void copyRootJoinsTo(EntityJoinTree<E, ID> entityJoinTree, String joinName) {
    }

    public <T extends Table<T>> EntityMapping<C, I, T> getMapping() {
        return new EntityMappingWrapper<C, I, T>(this.mainPersister.getMapping()){

            @Override
            public void addTransformerListener(RowTransformer.TransformerListener<C> listener) {
                super.addTransformerListener(listener);
                JoinTablePolymorphismPersister.this.subEntitiesPersisters.values().forEach(persister -> persister.getMapping().addTransformerListener(listener));
            }
        };
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsOne(RelationalEntityPersister<SRC, SRCID> sourcePersister, Accessor<SRC, C> propertyAccessor, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, String rightTableAlias, BeanRelationFixer<SRC, C> beanRelationFixer, boolean optional, boolean loadSeparately) {
        if (loadSeparately) {
            String mainTableJoinName = sourcePersister.getEntityJoinTree().addPassiveJoin("ROOT", leftColumn, rightColumn, optional ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, rightColumn.getColumns());
            PrimaryKey primaryKey = this.getMapping().getTargetTable().getPrimaryKey();
            this.subclassIdMappingStrategies.forEach((c, idMappingStrategy) -> {
                PrimaryKey subclassPrimaryKey = this.tablePerSubEntityType.get(c).getPrimaryKey();
                sourcePersister.getEntityJoinTree().addMergeJoin(mainTableJoinName, new FirstPhaseRelationLoader(idMappingStrategy, this, CURRENT_2PHASES_LOAD_CONTEXT), primaryKey, subclassPrimaryKey, EntityJoinTree.JoinType.OUTER);
            });
            sourcePersister.addSelectListener(new SecondPhaseRelationLoader(beanRelationFixer, CURRENT_2PHASES_LOAD_CONTEXT));
            return mainTableJoinName;
        }
        return this.join(sourcePersister.getEntityJoinTree(), "ROOT", this.mainPersister, propertyAccessor, leftColumn, rightColumn, new HashSet(this.subEntitiesPersisters.values()), beanRelationFixer, null);
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsMany(String joinName, RelationalEntityPersister<SRC, SRCID> sourcePersister, Accessor<SRC, ?> propertyAccessor, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, BeanRelationFixer<SRC, C> beanRelationFixer, @Nullable Function<ColumnedRow, Object> duplicateIdentifierProvider, Set<? extends Column<T2, ?>> selectableColumns, boolean optional, boolean loadSeparately) {
        if (loadSeparately) {
            String createdJoinName = sourcePersister.getEntityJoinTree().addPassiveJoin(joinName, leftColumn, rightColumn, optional ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, selectableColumns);
            this.subclassIdMappingStrategies.forEach((c, idMappingStrategy) -> {
                PrimaryKey subclassPrimaryKey = this.tablePerSubEntityType.get(c).getPrimaryKey();
                sourcePersister.getEntityJoinTree().addMergeJoin(createdJoinName, new FirstPhaseRelationLoader(idMappingStrategy, this, CURRENT_2PHASES_LOAD_CONTEXT), this.mainTablePrimaryKey, subclassPrimaryKey, EntityJoinTree.JoinType.OUTER);
            });
            sourcePersister.addSelectListener(new SecondPhaseRelationLoader(beanRelationFixer, CURRENT_2PHASES_LOAD_CONTEXT));
            return createdJoinName;
        }
        return this.join(sourcePersister.getEntityJoinTree(), joinName, this.mainPersister, propertyAccessor, leftColumn, rightColumn, new HashSet(this.subEntitiesPersisters.values()), beanRelationFixer, duplicateIdentifierProvider);
    }

    private <SRC, SRCID, U, T1 extends Table<T1>, T2 extends Table<T2>, ID, JOINID> String join(EntityJoinTree<SRC, SRCID> entityJoinTree, String leftStrategyName, ConfiguredRelationalPersister<U, ID> mainPersister, Accessor<SRC, ?> propertyAccessor, Key<T1, JOINID> leftJoinColumn, Key<T2, JOINID> rightJoinColumn, Set<ConfiguredRelationalPersister<? extends U, ID>> subPersisters, BeanRelationFixer<SRC, U> beanRelationFixer, @Nullable Function<ColumnedRow, Object> relationIdentifierProvider) {
        Hanger.Holder createdJoinHolder = new Hanger.Holder();
        String relationJoinName = entityJoinTree.addJoin(leftStrategyName, parent -> {
            JoinTablePolymorphicRelationJoinNode polymorphicRelationJoinNode = new JoinTablePolymorphicRelationJoinNode(parent, (Accessor<?, ?>)propertyAccessor, leftJoinColumn, rightJoinColumn, EntityJoinTree.JoinType.OUTER, mainPersister.getMainTable().getColumns(), null, new EntityInflater.EntityMappingAdapter(mainPersister.getMapping()), beanRelationFixer, (Function<ColumnedRow, ?>)relationIdentifierProvider);
            createdJoinHolder.set(polymorphicRelationJoinNode);
            return polymorphicRelationJoinNode;
        });
        this.addPolymorphicSubPersistersJoins(entityJoinTree, relationJoinName, mainPersister, (JoinTablePolymorphicRelationJoinNode)createdJoinHolder.get(), subPersisters);
        return relationJoinName;
    }

    private <SRC, SRCID, U, V extends U, T1 extends Table<T1>, T2 extends Table<T2>, ID> void addPolymorphicSubPersistersJoins(EntityJoinTree<SRC, SRCID> entityJoinTree, String mainPolymorphicJoinNodeName, ConfiguredRelationalPersister<U, ID> mainPersister, final JoinTablePolymorphicRelationJoinNode<U, T1, T2, ?, ID> mainPersisterJoin, Set<ConfiguredRelationalPersister<? extends U, ID>> subPersisters) {
        subPersisters.forEach(subPersister -> {
            final ConfiguredRelationalPersister localSubPersister = subPersister;
            entityJoinTree.addJoin(mainPolymorphicJoinNodeName, parent -> new MergeJoinNode<V, T1, T2, ID>((JoinNode)parent, (Key)mainPersister.getMainTable().getPrimaryKey(), (Key)subPersister.getMainTable().getPrimaryKey(), EntityJoinTree.JoinType.OUTER, null, new EntityMerger.EntityMergerAdapter(localSubPersister.getMapping())){

                @Override
                public MergeJoinNode.MergeJoinRowConsumer<V> toConsumer(JoinNode<V, T2> joinNode) {
                    PolymorphicMergeJoinRowConsumer joinRowConsumer = new PolymorphicMergeJoinRowConsumer((MergeJoinNode)joinNode, localSubPersister.getMapping());
                    mainPersisterJoin.addSubPersisterJoin(joinRowConsumer);
                    return joinRowConsumer;
                }
            });
        });
    }

    private /* synthetic */ void lambda$computeEntitiesPerPersister$11(Map entitiesPerType, Object entity) {
        this.subEntitiesPersisters.values().forEach(persister -> {
            if (persister.getClassToPersist().isInstance(entity)) {
                entitiesPerType.computeIfAbsent(persister, p -> new KeepOrderSet()).add(entity);
            }
        });
    }

    private /* synthetic */ void lambda$doUpdate$7(Map entitiesPerType, Duo payload) {
        this.subEntitiesPersisters.values().forEach(persister -> {
            Object entity = Objects.preventNull((Object)payload.getLeft(), (Object)payload.getRight());
            if (persister.getClassToPersist().isInstance(entity)) {
                entitiesPerType.computeIfAbsent(persister, p -> new KeepOrderSet()).add(payload);
            }
        });
    }
}

