/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.Savepoint;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codefilarete.stalactite.engine.VersioningStrategy;
import org.codefilarete.stalactite.engine.runtime.AbstractRevertOnRollbackMVCC;
import org.codefilarete.stalactite.engine.runtime.WriteExecutor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.RollbackListener;
import org.codefilarete.stalactite.sql.RollbackObserver;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSQL;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;

public class InsertExecutor<C, I, T extends Table<T>>
extends WriteExecutor<C, I, T>
implements org.codefilarete.stalactite.engine.InsertExecutor<C> {
    private OptimisticLockManager<C, T> optimisticLockManager = OptimisticLockManager.NOOP_OPTIMISTIC_LOCK_MANAGER;
    private final IdentifierInsertionManager<C, I> identifierInsertionManager;
    private SQLOperation.SQLOperationListener<Column<T, ?>> operationListener;

    public InsertExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize) {
        super(mappingStrategy, connectionConfiguration, dmlGenerator, writeOperationFactory, inOperatorMaxSize);
        this.identifierInsertionManager = mappingStrategy.getIdMapping().getIdentifierInsertionManager();
    }

    public <V> void setVersioningStrategy(VersioningStrategy<C, V> versioningStrategy) {
        if (!(this.getConnectionProvider() instanceof RollbackObserver)) {
            throw new UnsupportedOperationException("Version control is only supported for " + Reflections.toString(ConnectionProvider.class) + " that implements " + Reflections.toString(RollbackObserver.class));
        }
        Column versionColumn = this.getMapping().getPropertyToColumn().get(versioningStrategy.getVersionAccessor());
        this.setOptimisticLockManager(new RevertOnRollbackMVCC(versioningStrategy, versionColumn, (RollbackObserver)this.getConnectionProvider()));
    }

    public void setOptimisticLockManager(OptimisticLockManager<C, T> optimisticLockManager) {
        this.optimisticLockManager = optimisticLockManager;
    }

    public void setOperationListener(SQLOperation.SQLOperationListener<Column<T, ?>> listener) {
        this.operationListener = listener;
    }

    @Override
    public void insert(Iterable<? extends C> entities) {
        Set columns = this.getMapping().getInsertableColumns();
        ColumnParameterizedSQL insertStatement = this.getDmlGenerator().buildInsert(columns);
        List entitiesCopy = Iterables.copy(entities);
        WriteOperationFactory.ExpectedBatchedRowCountsSupplier expectedBatchedRowCountsSupplier = new WriteOperationFactory.ExpectedBatchedRowCountsSupplier(entitiesCopy.size(), this.getBatchSize());
        WriteOperation writeOperation = this.getWriteOperationFactory().createInstanceForInsertion(insertStatement, this.getConnectionProvider(), expectedBatchedRowCountsSupplier);
        writeOperation.setListener(this.operationListener);
        WriteExecutor.JDBCBatchingIterator<C> jdbcBatchingIterator = this.identifierInsertionManager.buildJDBCBatchingIterator(entitiesCopy, writeOperation, this.getBatchSize());
        jdbcBatchingIterator.forEachRemaining(entity -> {
            try {
                this.addToBatch(entity, writeOperation);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error while inserting values for " + entity + " in statement \"" + writeOperation.getSqlStatement().getSQL() + "\"", e);
            }
        });
    }

    private void addToBatch(C entity, WriteOperation<Column<T, ?>> writeOperation) {
        Map insertValues = this.getMapping().getInsertValues(entity);
        this.assertMandatoryColumnsHaveNonNullValues(insertValues);
        this.optimisticLockManager.manageLock(entity, insertValues);
        writeOperation.addBatch(insertValues);
    }

    private void assertMandatoryColumnsHaveNonNullValues(Map<Column<T, ?>, ?> insertValues) {
        Set nonNullColumnsWithNullValues = (Set)Iterables.collect(insertValues.entrySet(), e -> Boolean.FALSE.equals(((Column)e.getKey()).getNullable()) && e.getValue() == null, Map.Entry::getKey, HashSet::new);
        if (!nonNullColumnsWithNullValues.isEmpty()) {
            throw new SQLStatement.BindingException("Expected non null value for : " + new StringAppender().ccat((Iterable)Arrays.asTreeSet(Comparator.comparing(Column::getAbsoluteName), (Collection)nonNullColumnsWithNullValues), (Object)", "));
        }
    }

    static class VersioningStrategyRollbackListener<C, V>
    implements RollbackListener {
        private final VersioningStrategy<C, V> versioningStrategy;
        private final C instance;
        private final V previousVersion;

        public VersioningStrategyRollbackListener(VersioningStrategy<C, V> versioningStrategy, C instance, V previousVersion) {
            this.versioningStrategy = versioningStrategy;
            this.instance = instance;
            this.previousVersion = previousVersion;
        }

        public void beforeRollback() {
        }

        public void afterRollback() {
            this.versioningStrategy.revert(this.instance, this.previousVersion);
        }

        public void beforeRollback(Savepoint savepoint) {
        }

        public void afterRollback(Savepoint savepoint) {
        }

        public boolean isTemporary() {
            return true;
        }
    }

    private class RevertOnRollbackMVCC<V>
    extends AbstractRevertOnRollbackMVCC<C, V, T>
    implements OptimisticLockManager<C, T> {
        private RevertOnRollbackMVCC(VersioningStrategy<C, V> versioningStrategy, Column<T, V> versionColumn, RollbackObserver rollbackObserver) {
            super(versioningStrategy, versionColumn, rollbackObserver);
        }

        @Override
        public void manageLock(C instance, Map<Column<T, ?>, Object> updateValues) {
            Object previousVersion = this.versioningStrategy.getVersion(instance);
            this.versioningStrategy.upgrade(instance);
            Object newVersion = this.versioningStrategy.getVersion(instance);
            updateValues.put(this.versionColumn, newVersion);
            this.rollbackObserver.addRollbackListener(new VersioningStrategyRollbackListener(this.versioningStrategy, instance, previousVersion));
        }
    }

    public static interface OptimisticLockManager<E, T extends Table<T>> {
        public static final OptimisticLockManager<?, ?> NOOP_OPTIMISTIC_LOCK_MANAGER = (o, m) -> {};

        public void manageLock(E var1, Map<Column<T, ?>, Object> var2);
    }
}

