/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.DeleteExecutor;
import org.codefilarete.stalactite.engine.runtime.InsertExecutor;
import org.codefilarete.stalactite.engine.runtime.PersisterListenerWrapper;
import org.codefilarete.stalactite.engine.runtime.UpdateExecutor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.exception.NotImplementedException;

public class BeanPersister<C, I, T extends Table<T>>
extends PersisterListenerWrapper<C, I>
implements ConfiguredPersister<C, I> {
    private final EntityMapping<C, I, T> mappingStrategy;
    private final ConnectionConfiguration connectionConfiguration;
    private final DMLGenerator dmlGenerator;
    private final WriteOperationFactory writeOperationFactory;
    private final PersistExecutor<C> persistExecutor;
    private final InsertExecutor<C, I, T> insertExecutor;
    private final UpdateExecutor<C, I, T> updateExecutor;
    private final DeleteExecutor<C, I, T> deleteExecutor;
    private final SelectExecutor<C, I> selectExecutor;

    public BeanPersister(EntityMapping<C, I, T> mappingStrategy, PersistenceContext persistenceContext) {
        this(mappingStrategy, persistenceContext.getDialect(), persistenceContext.getConnectionConfiguration());
    }

    public BeanPersister(EntityMapping<C, I, T> mappingStrategy, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        this.mappingStrategy = mappingStrategy;
        this.connectionConfiguration = connectionConfiguration;
        this.dmlGenerator = dialect.getDmlGenerator();
        this.writeOperationFactory = dialect.getWriteOperationFactory();
        this.persistExecutor = this.newPersistExecutor();
        this.insertExecutor = this.newInsertExecutor(this.mappingStrategy, this.connectionConfiguration, this.dmlGenerator, this.writeOperationFactory, dialect.getInOperatorMaxSize());
        this.updateExecutor = this.newUpdateExecutor(this.mappingStrategy, this.connectionConfiguration, this.dmlGenerator, this.writeOperationFactory, dialect.getInOperatorMaxSize());
        this.deleteExecutor = this.newDeleteExecutor(this.mappingStrategy, this.connectionConfiguration, this.dmlGenerator, this.writeOperationFactory, dialect.getInOperatorMaxSize());
        this.selectExecutor = this.newSelectExecutor(this.mappingStrategy, this.connectionConfiguration, dialect);
        this.addInsertListener(this.getMapping().getIdMapping().getIdentifierInsertionManager().getInsertListener());
        this.addSelectListener(this.getMapping().getIdMapping().getIdentifierInsertionManager().getSelectListener());
    }

    protected PersistExecutor<C> newPersistExecutor() {
        return new PersistExecutor.DefaultPersistExecutor(this);
    }

    protected InsertExecutor<C, I, T> newInsertExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize) {
        return new InsertExecutor<C, I, T>(mappingStrategy, connectionConfiguration, dmlGenerator, writeOperationFactory, inOperatorMaxSize);
    }

    protected UpdateExecutor<C, I, T> newUpdateExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize) {
        return new UpdateExecutor<C, I, T>(mappingStrategy, connectionConfiguration, dmlGenerator, writeOperationFactory, inOperatorMaxSize);
    }

    protected DeleteExecutor<C, I, T> newDeleteExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize) {
        return new DeleteExecutor<C, I, T>(mappingStrategy, connectionConfiguration, dmlGenerator, writeOperationFactory, inOperatorMaxSize);
    }

    protected SelectExecutor<C, I> newSelectExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, Dialect dialect) {
        return new org.codefilarete.stalactite.engine.runtime.SelectExecutor<C, I, T>(mappingStrategy, connectionConfiguration, dialect.getDmlGenerator(), dialect.getReadOperationFactory(), dialect.getInOperatorMaxSize());
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionConfiguration.getConnectionProvider();
    }

    public DMLGenerator getDmlGenerator() {
        return this.dmlGenerator;
    }

    @Override
    public Class<C> getClassToPersist() {
        return this.getMapping().getClassToPersist();
    }

    @Override
    public EntityMapping<C, I, T> getMapping() {
        return this.mappingStrategy;
    }

    public T getMainTable() {
        return this.getMapping().getTargetTable();
    }

    @Override
    public Set<Table<?>> giveImpliedTables() {
        return Collections.singleton(this.getMainTable());
    }

    public InsertExecutor<C, I, T> getInsertExecutor() {
        return this.insertExecutor;
    }

    public UpdateExecutor<C, I, T> getUpdateExecutor() {
        return this.updateExecutor;
    }

    public DeleteExecutor<C, I, T> getDeleteExecutor() {
        return this.deleteExecutor;
    }

    public SelectExecutor<C, I> getSelectExecutor() {
        return this.selectExecutor;
    }

    @Override
    public EntityPersister.ExecutableEntityQuery<C, ?> selectWhere() {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public EntityPersister.ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<Select> selectAdapter) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public Set<C> selectAll() {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    protected void doPersist(Iterable<? extends C> entities) {
        this.persistExecutor.persist(entities);
    }

    @Override
    protected void doInsert(Iterable<? extends C> entities) {
        this.insertExecutor.insert(entities);
    }

    @Override
    protected void doUpdateById(Iterable<? extends C> entities) {
        this.updateExecutor.updateById(entities);
    }

    @Override
    protected void doUpdate(Iterable<? extends Duo<C, C>> entities, boolean allColumnsStatement) {
        this.updateExecutor.update(entities, allColumnsStatement);
    }

    @Override
    protected void doDelete(Iterable<? extends C> entities) {
        this.deleteExecutor.delete(entities);
    }

    @Override
    protected void doDeleteById(Iterable<? extends C> entities) {
        this.deleteExecutor.deleteById(entities);
    }

    @Override
    protected Set<C> doSelect(Iterable<I> ids) {
        return this.selectExecutor.select(ids);
    }

    @Override
    public boolean isNew(C c) {
        return this.mappingStrategy.isNew(c);
    }
}

