/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.util.Collections;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.SQLOperationsFactories;
import org.codefilarete.stalactite.engine.SQLOperationsFactoriesBuilder;
import org.codefilarete.stalactite.mapping.id.sequence.DatabaseSequenceSelector;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.DatabaseSequenceSelectorFactory;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.H2DialectResolver;
import org.codefilarete.stalactite.sql.ServiceLoaderDialectResolver;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.H2DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.H2ParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.H2TypeMapping;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.CaseInsensitiveSet;
import org.codefilarete.tool.collection.Sorter;

public class H2DatabaseSettings
extends DatabaseVendorSettings {
    @VisibleForTesting
    static final String[] KEYWORDS = new String[]{"ALL", "AND", "ANY", "ARRAY", "AS", "ASYMMETRIC", "AUTHORIZATION", "BETWEEN", "BOTH", "CASE", "CAST", "CHECK", "CONSTRAINT", "CROSS", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DAY", "DEFAULT", "DISTINCT", "ELSE", "END", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FOR", "FOREIGN", "FROM", "FULL", "GROUP", "GROUPS", "HAVING", "HOUR", "IF", "ILIKE", "IN", "INNER", "INTERSECT", "INTERVAL", "IS", "JOIN", "KEY", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "MINUS", "MINUTE", "MONTH", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "OR", "ORDER", "OVER", "PARTITION", "PRIMARY", "QUALIFY", "RANGE", "REGEXP", "RIGHT", "ROW", "ROWNUM", "ROWS", "SECOND", "SELECT", "SESSION_USER", "SET", "SOME", "SYMMETRIC", "SYSTEM_USER", "TABLE", "TO", "TOP", "TRAILING", "TRUE", "UESCAPE", "UNION", "UNIQUE", "UNKNOWN", "USER", "USING", "VALUE", "VALUES", "WHEN", "WHERE", "WINDOW", "WITH", "YEAR", "_ROWID_"};
    public static final H2DatabaseSettings H2_1_4 = new H2DatabaseSettings();

    private H2DatabaseSettings() {
        this(new H2SQLOperationsFactoriesBuilder(), new H2ParameterBinderRegistry());
    }

    private H2DatabaseSettings(H2SQLOperationsFactoriesBuilder h2SQLOperationsFactoriesBuilder, H2ParameterBinderRegistry parameterBinderRegistry) {
        super((ServiceLoaderDialectResolver.DatabaseSignet)new H2DialectResolver.H2DatabaseSignet(1, 4), Collections.unmodifiableSet(new CaseInsensitiveSet(KEYWORDS)), '\"', (JavaTypeToSqlTypeMapping)new H2TypeMapping(), (ParameterBinderRegistry)parameterBinderRegistry, (SQLOperationsFactoriesBuilder)h2SQLOperationsFactoriesBuilder, (GeneratedKeysReaderFactory)new GeneratedKeysReaderFactory.DefaultGeneratedKeysReaderFactory((ParameterBinderRegistry)parameterBinderRegistry), 1000, true);
    }

    private static class H2SequenceSelectorFactory
    implements DatabaseSequenceSelectorFactory {
        private final ReadOperationFactory readOperationFactory;

        private H2SequenceSelectorFactory(ReadOperationFactory readOperationFactory) {
            this.readOperationFactory = readOperationFactory;
        }

        public DatabaseSequenceSelector create(Sequence databaseSequence, ConnectionProvider connectionProvider) {
            return new DatabaseSequenceSelector(databaseSequence, "select next value for " + databaseSequence.getAbsoluteName(), this.readOperationFactory, connectionProvider);
        }
    }

    private static class H2SQLOperationsFactoriesBuilder
    implements SQLOperationsFactoriesBuilder {
        private final ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        private final WriteOperationFactory writeOperationFactory = new WriteOperationFactory();

        private H2SQLOperationsFactoriesBuilder() {
        }

        private ReadOperationFactory getReadOperationFactory() {
            return this.readOperationFactory;
        }

        private WriteOperationFactory getWriteOperationFactory() {
            return this.writeOperationFactory;
        }

        public SQLOperationsFactories build(ParameterBinderIndex<Column, ParameterBinder> parameterBinders, DMLNameProviderFactory dmlNameProviderFactory, SqlTypeRegistry sqlTypeRegistry) {
            DMLGenerator dmlGenerator = new DMLGenerator(parameterBinders, (Sorter)DMLGenerator.NoopSorter.INSTANCE, dmlNameProviderFactory);
            H2DDLTableGenerator ddlTableGenerator = new H2DDLTableGenerator(sqlTypeRegistry, dmlNameProviderFactory);
            DDLSequenceGenerator ddlSequenceGenerator = new DDLSequenceGenerator(dmlNameProviderFactory);
            return new SQLOperationsFactories(this.writeOperationFactory, this.readOperationFactory, dmlGenerator, (DDLTableGenerator)ddlTableGenerator, ddlSequenceGenerator, (DatabaseSequenceSelectorFactory)new H2SequenceSelectorFactory(this.readOperationFactory));
        }
    }
}

