/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.sql.ResultSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.codefilarete.stalactite.sql.result.ColumnReader;
import org.codefilarete.stalactite.sql.result.ResultSetRowAssembler;
import org.codefilarete.stalactite.sql.result.SingleColumnReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;

public class ColumnConsumer<C, I>
implements ResultSetRowAssembler<C> {
    private final ColumnReader<I> reader;
    private final BiConsumer<C, I> propertySetter;

    public ColumnConsumer(ColumnReader<I> reader, BiConsumer<C, I> propertySetter) {
        this.reader = reader;
        this.propertySetter = propertySetter;
    }

    public ColumnConsumer(String columnName, ResultSetReader<I> reader, BiConsumer<C, I> propertySetter) {
        this(new SingleColumnReader<I>(columnName, reader), propertySetter);
    }

    public ColumnReader<I> getReader() {
        return this.reader;
    }

    public BiConsumer<C, I> getPropertySetter() {
        return this.propertySetter;
    }

    @Override
    public void assemble(C instance, ResultSet resultSet) {
        this.propertySetter.accept(instance, this.reader.read(resultSet));
    }

    public ColumnConsumer<C, I> copyWithAliases(Function<String, String> columnMapping) {
        return new ColumnConsumer<C, I>(this.reader.copyWithAliases(columnMapping), this.propertySetter);
    }
}

